/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Patrick R Wardrop (IBM Corporation)
 *******************************************************************************/
package org.eclipse.higgins.cardstore.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;

import javax.security.auth.callback.PasswordCallback;

import org.eclipse.higgins.cardstore.CardStoreBuilderFactory;
import org.eclipse.higgins.cardstore.ICardStoreBuilder;
import org.eclipse.higgins.cardstore.exceptions.StoreEncryptionException;
import org.eclipse.higgins.cardstore.schemas._2005._05.identity.IEncryptedStore;
import org.eclipse.higgins.cardstore.schemas._2005._05.identity.IRoamingInformationCard;
import org.eclipse.higgins.cardstore.schemas._2005._05.identity.IRoamingStore;

public class Tester1 {

	public static void main(String[] args) throws Exception {
		char[] passwdSrc = new char[] { 'p', 'a', 's', 's', 'w', '0', 'r', 'd' };
		char[] passwdDest = new char[] { 'i', 'b', 'm', 'i', 'b', 'm', 'i',
				'b', 'm' };
		String srcCardsFile = "/tmp/tonio.crds";
		String destCardsFile = "/tmp/tonycards.crds";

		IRoamingStore srcCards = readInStore(srcCardsFile, passwdSrc);
		IRoamingStore destCards = readInStore(destCardsFile, passwdDest);

		String idToUse = "https://infocard.pingidentity.com/idpdemo/sts/cards/tonio";
		IRoamingInformationCard card = srcCards
				.getRoamingInformationCardByCardId(idToUse);

		destCards.addRoamingInformationCard(card);

		// write out to disk both stores
		destCardsFile = "/tmp/tonycards_new.crds";
		writeOutStore(destCards, destCardsFile, passwdDest);
		System.out.println("Created new [" + destCardsFile + "] last modif: "
				+ new Date(new File(destCardsFile).lastModified()));
		System.out.println("Current time:" + new Date());
	}

	private static void writeOutStore(IRoamingStore store, String filename,
			char[] passwd) throws StoreEncryptionException, IOException {
		ICardStoreBuilder builder = CardStoreBuilderFactory
				.newCardStoreBuilder();

		IEncryptedStore es = builder.createEncryptedStore();
		;
		es.setRoamingStore(store);

		PasswordCallback pc = new PasswordCallback("What is your password: ",
				true);
		pc.setPassword(passwd);

		long timeStart = System.currentTimeMillis();
		byte[] esBytes = es.toXml(pc);
		long timeStop = System.currentTimeMillis();

		System.out.println("total time (encrypt): [" + filename + "]"
				+ (timeStop - timeStart));

		FileOutputStream fos = new FileOutputStream(new File(filename));
		fos.write(esBytes);
		fos.flush();
		fos.close();
	}

	private static IRoamingStore readInStore(String filename, char[] passwd)
			throws Exception {
		ICardStoreBuilder builder = CardStoreBuilderFactory
				.newCardStoreBuilder();

		IEncryptedStore es = null;

		PasswordCallback pc = new PasswordCallback("What is your password: ",
				true);
		pc.setPassword(passwd);
		File crdsFile = new File(filename);
		byte[] crdsBytes = new byte[(int) crdsFile.length()];
		FileInputStream fis = new FileInputStream(crdsFile);
		fis.read(crdsBytes);

		long timeStart = System.currentTimeMillis();

		es = builder.createEncryptedStore(crdsBytes);
		IRoamingStore rs = es.getRoamingStore(pc);
		long timeStop = System.currentTimeMillis();

		System.out.println("total time (decrypt): [" + filename + "]"
				+ (timeStop - timeStart));

		return rs;
	}

}
