/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.cardstore.schemas._2000._09.xmldsig.impl;

import java.io.ByteArrayInputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.eclipse.higgins.cardstore.exceptions.ExpectedObjectNotPresent;
import org.eclipse.higgins.cardstore.exceptions.UnsupportedObjectModel;
import org.eclipse.higgins.cardstore.logging.Log;
import org.eclipse.higgins.cardstore.logging.LogHelper;
import org.eclipse.higgins.cardstore.schemas._2000._09.xmldsig.IX509Data;
import org.eclipse.higgins.cardstore.utils.Base64Utility;
import org.eclipse.higgins.cardstore.utils.MessageHelper;
import org.eclipse.higgins.cardstore.utils.XmlUtils;
import org.w3c.dom.Element;

public class X509Data
implements IX509Data {
    public static String copyright = "Licensed Materials - Property of IBM\n(C) Copyright IBM Corporation 2004, 2005, 2007. All Rights Reserved.\nU.S. Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n";
    private static Log _log = LogHelper.getLogger(class$org$eclipse$higgins$cardstore$schemas$_2000$_09$xmldsig$impl$X509Data == null ? (class$org$eclipse$higgins$cardstore$schemas$_2000$_09$xmldsig$impl$X509Data = X509Data.class$("org.eclipse.higgins.cardstore.schemas._2000._09.xmldsig.impl.X509Data")) : class$org$eclipse$higgins$cardstore$schemas$_2000$_09$xmldsig$impl$X509Data);
    private Element _x509DataElement = null;
    private X509Certificate _x509Certificate = null;
    Object _parent = null;
    static /* synthetic */ Class class$org$eclipse$higgins$cardstore$schemas$_2000$_09$xmldsig$impl$X509Data;

    public void setParent(Object parentNode) {
        this._parent = parentNode;
    }

    public Object getParent() {
        return this._parent;
    }

    public void fromXml(Object obj) throws UnsupportedObjectModel, ExpectedObjectNotPresent {
        byte[] certBytes;
        String s;
        this._x509DataElement = XmlUtils.retrieveElementFromObject(obj);
        if (!XmlUtils.isElementType(this._x509DataElement, "X509Data", "http://www.w3.org/2000/09/xmldsig#") || this._x509DataElement == null) {
            this._x509DataElement = null;
            throw new ExpectedObjectNotPresent(MessageHelper.getMessage("expected_object_not_present", new Object[]{"http://www.w3.org/2000/09/xmldsig#:X509Data"}));
        }
        Element _x509CertificateElement = XmlUtils.retrieveFirstChildMatchOfType(this._x509DataElement, "X509Certificate", "http://www.w3.org/2000/09/xmldsig#");
        if (_x509CertificateElement != null && (s = XmlUtils.retrieveAllTextFromChildTextNodes(_x509CertificateElement)) != null && s.length() > 0 && (certBytes = Base64Utility.decode(s)) != null && certBytes.length > 0) {
            try {
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                ByteArrayInputStream bais = new ByteArrayInputStream(certBytes);
                this.setX509Certificate((X509Certificate)cf.generateCertificate(bais));
            }
            catch (Exception e) {
                _log.error(null, e);
            }
        }
    }

    public Object toXml() {
        return this._x509DataElement;
    }

    public X509Certificate getX509Certificate() {
        return this._x509Certificate;
    }

    public void setX509Certificate(X509Certificate cert) {
        this._x509Certificate = cert;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

