/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.cardstore.schemas._2005._05.identity.impl;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.callback.PasswordCallback;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.higgins.cardstore.exceptions.ExpectedObjectNotPresent;
import org.eclipse.higgins.cardstore.exceptions.StoreDecryptionException;
import org.eclipse.higgins.cardstore.exceptions.StoreEncryptionException;
import org.eclipse.higgins.cardstore.exceptions.UnsupportedObjectModel;
import org.eclipse.higgins.cardstore.logging.Log;
import org.eclipse.higgins.cardstore.logging.LogHelper;
import org.eclipse.higgins.cardstore.schemas._2005._05.identity.IEncryptedStore;
import org.eclipse.higgins.cardstore.schemas._2005._05.identity.IRoamingStore;
import org.eclipse.higgins.cardstore.schemas._2005._05.identity.impl.RoamingStore;
import org.eclipse.higgins.cardstore.utils.Base64Utility;
import org.eclipse.higgins.cardstore.utils.HexDumper;
import org.eclipse.higgins.cardstore.utils.MessageHelper;
import org.eclipse.higgins.cardstore.utils.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class EncryptedStore
implements IEncryptedStore {
    public static String copyright = "Licensed Materials - Property of IBM\n(C) Copyright IBM Corporation 2004, 2005, 2007. All Rights Reserved.\nU.S. Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n";
    private static Log _log = LogHelper.getLogger(class$org$eclipse$higgins$cardstore$schemas$_2005$_05$identity$impl$EncryptedStore == null ? (class$org$eclipse$higgins$cardstore$schemas$_2005$_05$identity$impl$EncryptedStore = EncryptedStore.class$("org.eclipse.higgins.cardstore.schemas._2005._05.identity.impl.EncryptedStore")) : class$org$eclipse$higgins$cardstore$schemas$_2005$_05$identity$impl$EncryptedStore);
    private static final String STORE_KEY_TYPE = "AES";
    private static final String STORE_CIPHER = "AES/CBC/PKCS5Padding";
    private static final String UTF8 = "UTF-8";
    private static final String UTF16LE = "UTF-16LE";
    private static byte[] ENC_KEY_ENTROPY = new byte[]{-39, 89, 123, 38, 30, -40, -77, 68, -109, 35, -77, -106, -123, -34, -107, -4};
    private static byte[] SIG_KEY_ENTROPY = new byte[]{-60, 1, 123, -15, 107, -83, 47, 66, -81, -12, -105, 125, 4, 104, 3, -37};
    private static byte[] BYTE_ORDER_MARK = new byte[]{-17, -69, -65};
    private byte[] _byteOrderMark = null;
    private byte[] _crdsBytes = null;
    private byte[] _storeSalt = null;
    private Document _rootDocument = null;
    private Element _encryptedStoreElement = null;
    private IRoamingStore _roamingStore = null;
    private static SecureRandom _randomGenerator = null;
    static /* synthetic */ Class class$org$eclipse$higgins$cardstore$schemas$_2005$_05$identity$impl$EncryptedStore;

    public Object getParent() {
        return this.getRootDocument();
    }

    public void setParent(Object parent) {
    }

    public EncryptedStore() {
        this._byteOrderMark = BYTE_ORDER_MARK;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            this._rootDocument = db.newDocument();
            Element roamingStoreElement = this._rootDocument.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "RoamingStore");
            this._rootDocument.appendChild(roamingStoreElement);
            this._roamingStore = new RoamingStore();
            try {
                this._roamingStore.fromXml(roamingStoreElement);
                ((RoamingStore)this._roamingStore).setParent(this);
            }
            catch (Exception e) {
                _log.error(null, e);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public EncryptedStore(byte[] crdsBytes) throws UnsupportedObjectModel, ExpectedObjectNotPresent {
        this._crdsBytes = crdsBytes;
        this._byteOrderMark = EncryptedStore.retrieveByteOrderMark(this._crdsBytes);
        Element encryptedStoreElement = this.retrieveStoreXmlMessage(this._crdsBytes);
        this.fromXml(encryptedStoreElement);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Element retrieveDecryptXmlStore(char[] password) throws StoreDecryptionException {
        String method = "retrieveDecryptXmlStore";
        _log.enterMethod(method);
        Element result = null;
        if (this._encryptedStoreElement != null) {
            Element encryptedData = XmlUtils.retrieveFirstChildMatchOfType(this._encryptedStoreElement, "EncryptedData", "http://www.w3.org/2001/04/xmlenc#");
            if (encryptedData == null) throw new StoreDecryptionException(MessageHelper.getMessage("encrypted_store_could_not_be_decrypted_encrypteddata_not_present", null));
            Element cipherData = XmlUtils.retrieveFirstChildMatchOfType(encryptedData, "CipherData", "http://www.w3.org/2001/04/xmlenc#");
            if (cipherData == null) throw new StoreDecryptionException(MessageHelper.getMessage("encrypted_store_could_not_be_decrypted_cipherdata_not_present", null));
            Element cipherValue = XmlUtils.retrieveFirstChildMatchOfType(cipherData, "CipherValue", "http://www.w3.org/2001/04/xmlenc#");
            if (cipherValue == null) throw new StoreDecryptionException(MessageHelper.getMessage("encrypted_store_could_not_be_decrypted_ciphervalue_not_present", null));
            String base64CipherValue = XmlUtils.retrieveAllTextFromChildTextNodes(cipherValue);
            if (base64CipherValue == null || base64CipherValue.length() <= 0) throw new StoreDecryptionException(MessageHelper.getMessage("encrypted_store_could_not_be_decrypted_ciphervalue_no_data", null));
            _log.trace(method, "base64 encoded cipher value retrieved is: " + base64CipherValue);
            try {
                byte[] roamingStoreBytes = this.decrypt(base64CipherValue, password, this.getStoreSalt());
                if (roamingStoreBytes != null) {
                    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                    dbf.setNamespaceAware(true);
                    DocumentBuilder db = dbf.newDocumentBuilder();
                    Document doc = db.parse(new ByteArrayInputStream(roamingStoreBytes));
                    if (doc != null) {
                        result = doc.getDocumentElement();
                    }
                }
            }
            catch (Exception e) {
                throw new StoreDecryptionException(MessageHelper.getMessage("encrypted_store_could_not_be_decrypted", null), e);
            }
        }
        if (result == null) {
            throw new StoreDecryptionException(MessageHelper.getMessage("encrypted_store_could_not_be_decrypted", null));
        }
        _log.exitMethod(method, result);
        return result;
    }

    private byte[] retrieveStoreSalt(Element encryptedStore) {
        String s;
        Element storeSaltElement;
        String method = "retrieveStoreSalt";
        _log.enterMethod(method, new Object[]{encryptedStore});
        byte[] result = null;
        if (encryptedStore != null && (storeSaltElement = XmlUtils.retrieveFirstChildMatchOfType(encryptedStore, "StoreSalt", "http://schemas.xmlsoap.org/ws/2005/05/identity")) != null && (s = XmlUtils.retrieveAllTextFromChildTextNodes(storeSaltElement)) != null && s.length() > 0) {
            result = Base64Utility.decode(s);
        }
        _log.exitMethod(method, result);
        return result;
    }

    private Element retrieveStoreXmlMessage(byte[] bytes) {
        String method = "retrieveStoreXmlMessage";
        _log.enterMethod(method, new Object[]{bytes});
        Element result = null;
        if (bytes != null) {
            Document doc = null;
            try {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setNamespaceAware(true);
                DocumentBuilder db = dbf.newDocumentBuilder();
                doc = db.parse(new ByteArrayInputStream(bytes));
            }
            catch (Exception e) {
                _log.error(null, e);
            }
            result = doc.getDocumentElement();
        }
        _log.exitMethod(method, result);
        return result;
    }

    private static byte[] retrieveByteOrderMark(byte[] crdsBytes) {
        String method = "retrieveByteOrderMark";
        _log.enterMethod(method, new Object[]{crdsBytes});
        byte[] result = null;
        if (crdsBytes != null && crdsBytes.length > 5) {
            result = new byte[3];
            int i = 0;
            for (i = 0; i < 3; ++i) {
                result[i] = crdsBytes[i];
            }
            if (crdsBytes[i] != 60 || crdsBytes[i + 1] != 63) {
                _log.trace(method, "the first three bytes weren't the byte order mark.");
                _log.warn(MessageHelper.getMessage("first_three_bytes_were_not_byte_order_mark", null));
                result = null;
            }
        }
        _log.trace(method, "the byte order mark return is: " + HexDumper.byteArrayToHexString(result));
        _log.exitMethod(method, result);
        return result;
    }

    public byte[] getByteOrderMark() {
        if (this._byteOrderMark == null) {
            this._byteOrderMark = EncryptedStore.retrieveByteOrderMark(this._crdsBytes);
        }
        return this._byteOrderMark;
    }

    public byte[] getStoreSalt() {
        return this._storeSalt;
    }

    private byte[] decrypt(String ciphertext, char[] password, byte[] salt) throws StoreDecryptionException {
        byte[] result = null;
        try {
            byte[] ct = Base64Utility.decode(ciphertext);
            byte[] iv = new byte[16];
            byte[] ic = new byte[32];
            byte[] da = new byte[ct.length - iv.length - ic.length];
            System.arraycopy(ct, 0, iv, 0, 16);
            System.arraycopy(ct, 16, ic, 0, 32);
            System.arraycopy(ct, 48, da, 0, da.length);
            byte[][] keysBytes = this.makeKeys(password, salt);
            SecretKeySpec encKey = new SecretKeySpec(keysBytes[0], STORE_KEY_TYPE);
            Cipher cipher = Cipher.getInstance(STORE_CIPHER);
            IvParameterSpec ips = new IvParameterSpec(iv);
            cipher.init(2, (Key)encKey, ips);
            byte[] out = cipher.doFinal(da);
            if (out[0] == BYTE_ORDER_MARK[0] && out[1] == BYTE_ORDER_MARK[1] && out[2] == BYTE_ORDER_MARK[2]) {
                result = new byte[out.length - 3];
                System.arraycopy(out, 3, result, 0, out.length - 3);
            } else {
                result = new byte[out.length];
                System.arraycopy(out, 0, result, 0, out.length);
            }
            byte[] last_block = new byte[16];
            System.arraycopy(out, out.length - 16, last_block, 0, 16);
            if (!this.isSignatureValid(iv, last_block, keysBytes[1], ic)) {
                throw new StoreDecryptionException(MessageHelper.getMessage("encrypted_store_integrity_check_failed", null));
            }
        }
        catch (Exception e) {
            throw new StoreDecryptionException(e);
        }
        return result;
    }

    private byte[] encrypt(byte[] cleartext, char[] password, byte[] salt) throws StoreEncryptionException {
        byte[] result = null;
        try {
            byte[] in = new byte[BYTE_ORDER_MARK.length + cleartext.length];
            System.arraycopy(BYTE_ORDER_MARK, 0, in, 0, BYTE_ORDER_MARK.length);
            System.arraycopy(cleartext, 0, in, BYTE_ORDER_MARK.length, cleartext.length);
            byte[] iv = new byte[16];
            EncryptedStore.generateRandomBytes(iv);
            byte[][] keysBytes = this.makeKeys(password, salt);
            SecretKeySpec encKey = new SecretKeySpec(keysBytes[0], STORE_KEY_TYPE);
            Cipher cipher = Cipher.getInstance(STORE_CIPHER);
            IvParameterSpec ips = new IvParameterSpec(iv);
            cipher.init(1, (Key)encKey, ips);
            byte[] out = cipher.doFinal(in);
            byte[] last_block = new byte[16];
            System.arraycopy(in, in.length - last_block.length, last_block, 0, last_block.length);
            byte[] ic = this.calculateHashedIntegrityCode(iv, last_block, keysBytes[1]);
            result = new byte[iv.length + ic.length + out.length];
            System.arraycopy(iv, 0, result, 0, iv.length);
            System.arraycopy(ic, 0, result, iv.length, ic.length);
            System.arraycopy(out, 0, result, iv.length + ic.length, out.length);
        }
        catch (Exception e) {
            throw new StoreEncryptionException(e);
        }
        return result;
    }

    private static void generateRandomBytes(byte[] b) throws NoSuchAlgorithmException {
        if (b == null) {
            return;
        }
        if (_randomGenerator == null) {
            _randomGenerator = SecureRandom.getInstance("SHA1PRNG");
        }
        _randomGenerator.nextBytes(b);
    }

    private boolean isSignatureValid(byte[] iv, byte[] last_block, byte[] ik, byte[] ic) throws NoSuchAlgorithmException {
        byte[] icCalc = this.calculateHashedIntegrityCode(iv, last_block, ik);
        return Arrays.equals(ic, icCalc);
    }

    private byte[] calculateHashedIntegrityCode(byte[] iv, byte[] last_block, byte[] ik) throws NoSuchAlgorithmException {
        MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
        sha256.reset();
        byte[] dataBytes = new byte[iv.length + ik.length + last_block.length];
        System.arraycopy(iv, 0, dataBytes, 0, iv.length);
        System.arraycopy(ik, 0, dataBytes, iv.length, ik.length);
        System.arraycopy(last_block, 0, dataBytes, iv.length + ik.length, last_block.length);
        sha256.update(dataBytes);
        return sha256.digest();
    }

    private byte[] convertCharArrayToByteArray(char[] chars) {
        if (chars == null) {
            return null;
        }
        byte[] newbytes8 = null;
        Charset utf8char = Charset.forName(UTF16LE);
        CharsetEncoder utf8ncd = utf8char.newEncoder();
        CharBuffer buf8 = CharBuffer.allocate(chars.length);
        buf8.put(chars).position(0);
        try {
            ByteBuffer bb1 = utf8ncd.encode(buf8);
            newbytes8 = new byte[bb1.limit() - bb1.position()];
            bb1.get(newbytes8);
        }
        catch (CharacterCodingException cce) {
            throw new RuntimeException(cce.getMessage(), cce);
        }
        return newbytes8;
    }

    public byte[][] makeKeys(char[] password, byte[] salt) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
        sha256.update(this.convertCharArrayToByteArray(password));
        sha256.update(salt);
        byte[] digestBytes = sha256.digest();
        for (int i = 1; i < 1000; ++i) {
            sha256.update(digestBytes);
            digestBytes = sha256.digest();
        }
        sha256.reset();
        byte[] encKeyBytes = new byte[ENC_KEY_ENTROPY.length + digestBytes.length];
        System.arraycopy(ENC_KEY_ENTROPY, 0, encKeyBytes, 0, ENC_KEY_ENTROPY.length);
        System.arraycopy(digestBytes, 0, encKeyBytes, ENC_KEY_ENTROPY.length, digestBytes.length);
        sha256.update(encKeyBytes);
        byte[] ek = sha256.digest();
        sha256.reset();
        byte[] sigKeyBytes = new byte[SIG_KEY_ENTROPY.length + digestBytes.length];
        System.arraycopy(SIG_KEY_ENTROPY, 0, sigKeyBytes, 0, SIG_KEY_ENTROPY.length);
        System.arraycopy(digestBytes, 0, sigKeyBytes, SIG_KEY_ENTROPY.length, digestBytes.length);
        sha256.update(sigKeyBytes);
        byte[] ik = sha256.digest();
        byte[][] result = new byte[][]{ek, ik};
        return result;
    }

    public synchronized IRoamingStore getRoamingStore(PasswordCallback passwdCallback) throws StoreDecryptionException {
        Element roamingStoreElement = null;
        if (this._roamingStore == null && passwdCallback != null && passwdCallback.getPassword() != null) {
            roamingStoreElement = this.retrieveDecryptXmlStore(passwdCallback.getPassword());
        }
        if (this._roamingStore != null || roamingStoreElement != null) {
            // empty if block
        }
        this._roamingStore = new RoamingStore();
        try {
            this._roamingStore.fromXml(roamingStoreElement);
            ((RoamingStore)this._roamingStore).setParent(this);
        }
        catch (Exception e) {
            _log.error(null, e);
        }
        return this._roamingStore;
    }

    public synchronized void fromXml(Object obj) throws UnsupportedObjectModel, ExpectedObjectNotPresent {
        this._encryptedStoreElement = XmlUtils.retrieveElementFromObject(obj);
        if (this._encryptedStoreElement != null) {
            if (!XmlUtils.isElementType(this._encryptedStoreElement, "EncryptedStore", "http://schemas.xmlsoap.org/ws/2005/05/identity")) {
                this._encryptedStoreElement = null;
                throw new ExpectedObjectNotPresent("The expected object http://schemas.xmlsoap.org/ws/2005/05/identity:EncryptedStore was not present.");
            }
            this._rootDocument = this._encryptedStoreElement.getOwnerDocument();
            this._storeSalt = this.retrieveStoreSalt(this._encryptedStoreElement);
        }
    }

    public Object toXml() {
        throw new UnsupportedOperationException(MessageHelper.getMessage("encrypted_store_to_xml_w_password_should_be_called", null));
    }

    public synchronized byte[] toXml(PasswordCallback passwdCallback) throws StoreEncryptionException {
        try {
            byte[] salt = new byte[16];
            EncryptedStore.generateRandomBytes(salt);
            String roamingStoreString = XmlUtils.getString((Node)this._roamingStore.toXml());
            if (roamingStoreString != null && roamingStoreString.length() > 0) {
                byte[] encryptedRoamingStoreBytes = this.encrypt(roamingStoreString.getBytes(UTF8), passwdCallback.getPassword(), salt);
                this._storeSalt = salt;
                this._encryptedStoreElement = this.createEncryptedStoreElement(encryptedRoamingStoreBytes, salt);
                if (this._encryptedStoreElement != null) {
                    String encryptedStoreString = XmlUtils.getString(this._encryptedStoreElement);
                    byte[] encryptedStoreElementBytes = encryptedStoreString.getBytes(UTF8);
                    this._crdsBytes = new byte[BYTE_ORDER_MARK.length + encryptedStoreElementBytes.length];
                    System.arraycopy(BYTE_ORDER_MARK, 0, this._crdsBytes, 0, BYTE_ORDER_MARK.length);
                    System.arraycopy(encryptedStoreElementBytes, 0, this._crdsBytes, BYTE_ORDER_MARK.length, encryptedStoreElementBytes.length);
                }
            }
        }
        catch (Exception e) {
            throw new StoreEncryptionException(e);
        }
        return this._crdsBytes;
    }

    private Element createEncryptedStoreElement(byte[] encryptedRoamingStoreBytes, byte[] salt) throws ParserConfigurationException {
        this._rootDocument = XmlUtils.newDocument();
        Element encryptedStoreElement = this._rootDocument.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "EncryptedStore");
        encryptedStoreElement.setAttribute("xmlns", "http://schemas.xmlsoap.org/ws/2005/05/identity");
        this._rootDocument.appendChild(encryptedStoreElement);
        Element storeSaltElement = this._rootDocument.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "StoreSalt");
        encryptedStoreElement.appendChild(storeSaltElement);
        Text storeSaltText = this._rootDocument.createTextNode(Base64Utility.encode(salt));
        storeSaltElement.appendChild(storeSaltText);
        Element encryptedDataElement = this._rootDocument.createElementNS("http://www.w3.org/2001/04/xmlenc#", "EncryptedData");
        encryptedDataElement.setAttribute("xmlns", "http://www.w3.org/2001/04/xmlenc#");
        encryptedStoreElement.appendChild(encryptedDataElement);
        Element cipherDataElement = this._rootDocument.createElementNS("http://www.w3.org/2001/04/xmlenc#", "CipherData");
        encryptedDataElement.appendChild(cipherDataElement);
        Element cipherValueElement = this._rootDocument.createElementNS("http://www.w3.org/2001/04/xmlenc#", "CipherValue");
        cipherDataElement.appendChild(cipherValueElement);
        Text cipherValueText = this._rootDocument.createTextNode(Base64Utility.encode(encryptedRoamingStoreBytes));
        cipherValueElement.appendChild(cipherValueText);
        return encryptedStoreElement;
    }

    public Document getRootDocument() {
        if (this._rootDocument == null) {
            try {
                this._rootDocument = XmlUtils.newDocument();
            }
            catch (ParserConfigurationException e) {
                _log.error(null, e);
            }
        }
        return this._rootDocument;
    }

    public static void main(String[] args) throws Exception {
        boolean go = true;
        int x = 0;
        while (go) {
            ++x;
            EncryptedStore es = null;
            PasswordCallback pc = new PasswordCallback("What is your password: ", true);
            pc.setPassword(new String("passw0rd").toCharArray());
            File crdsFile = new File("c:/temp/mycards.crds");
            byte[] crdsBytes = new byte[(int)crdsFile.length()];
            FileInputStream fis = new FileInputStream(crdsFile);
            fis.read(crdsBytes);
            long timeStart = System.currentTimeMillis();
            es = new EncryptedStore(crdsBytes);
            IRoamingStore rs = es.getRoamingStore(pc);
            long timeStop = System.currentTimeMillis();
            System.out.println("total time (decrypt): " + (timeStop - timeStart));
            pc = new PasswordCallback("What is your password: ", true);
            pc = new PasswordCallback("What is your password: ", true);
            pc.setPassword(new String("mercury1").toCharArray());
            long timeStart2 = System.currentTimeMillis();
            byte[] esBytes = es.toXml(pc);
            long timeStop2 = System.currentTimeMillis();
            System.out.println("total time (encrypt): " + (timeStop2 - timeStart2));
            FileOutputStream fos = new FileOutputStream(new File("c:/temp/new_mycards.crds"));
            fos.write(esBytes);
            fos.flush();
            fos.close();
            pc = new PasswordCallback("What is your password: ", true);
            pc.setPassword(new String("mercury1").toCharArray());
            crdsFile = new File("c:/temp/new_mycards.crds");
            crdsBytes = new byte[(int)crdsFile.length()];
            fis = new FileInputStream(crdsFile);
            fis.read(crdsBytes);
            timeStart = System.currentTimeMillis();
            es = new EncryptedStore(crdsBytes);
            rs = es.getRoamingStore(pc);
            timeStop = System.currentTimeMillis();
            System.out.println("total time (decrypt2): " + (timeStop - timeStart));
            es = null;
            pc = new PasswordCallback("What is your password: ", true);
            pc.setPassword(new String("ibmibmibm").toCharArray());
            crdsFile = new File("c:/temp/tonycards.crds");
            crdsBytes = new byte[(int)crdsFile.length()];
            fis = new FileInputStream(crdsFile);
            fis.read(crdsBytes);
            timeStart = System.currentTimeMillis();
            es = new EncryptedStore(crdsBytes);
            rs = es.getRoamingStore(pc);
            timeStop = System.currentTimeMillis();
            System.out.println("total time (decrypt): " + (timeStop - timeStart));
            pc = new PasswordCallback("What is your password: ", true);
            pc = new PasswordCallback("What is your password: ", true);
            pc.setPassword(new String("mercury2").toCharArray());
            timeStart = System.currentTimeMillis();
            esBytes = es.toXml(pc);
            timeStop2 = System.currentTimeMillis();
            System.out.println("total time (encrypt): " + (timeStop2 - timeStart));
            fos = new FileOutputStream(new File("c:/temp/new_tonycards.crds"));
            fos.write(esBytes);
            fos.flush();
            fos.close();
            pc = new PasswordCallback("What is your password: ", true);
            pc.setPassword(new String("mercury2").toCharArray());
            crdsFile = new File("c:/temp/new_tonycards.crds");
            crdsBytes = new byte[(int)crdsFile.length()];
            fis = new FileInputStream(crdsFile);
            fis.read(crdsBytes);
            timeStart = System.currentTimeMillis();
            es = new EncryptedStore(crdsBytes);
            rs = es.getRoamingStore(pc);
            timeStop = System.currentTimeMillis();
            System.out.println("total time (decrypt2): " + (timeStop - timeStart));
            if (x <= 1) continue;
            go = false;
        }
        System.out.println("Done.");
    }

    public void setRoamingStore(IRoamingStore roamingStore) {
        this._roamingStore = roamingStore;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

