/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Patrick R Wardrop (IBM Corporation)
 *******************************************************************************/ 
package org.eclipse.higgins.cardstore.utils;

import org.eclipse.higgins.cardstore.Constants;
import org.eclipse.higgins.cardstore.logging.Log;
import org.eclipse.higgins.cardstore.logging.LogHelper;

import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class Base64Utility {
	public static String copyright = Constants.FULL_COPYRIGHT;
	
	private static Log _log = LogHelper.getLogger(Base64Utility.class);
	
	public static byte[] decode(String base64String)
	{
		if (base64String == null)
		{
			return null;
		}
		
		byte[] result = null;
		
		try {
			result = (new BASE64Decoder()).decodeBuffer(base64String);
		} catch (Exception e) {
			_log.error(null, e);
		}
		
		return result;
	}

	public static String encode(byte[] buf)
	{
		if (buf == null)
		{
			return null;
		}
		
		String result = null;
		
		try {
			BASE64Encoder encoder = new BASE64Encoder();			
			result = encoder.encodeBuffer(buf);
			result = result.replaceAll(System.getProperty("line.separator"), "");
		} catch (Exception e) {
			_log.error(null, e);
		}		
		
		return result;
	}
	
}
