/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Patrick R Wardrop (IBM Corporation)
 *******************************************************************************/ 
package org.eclipse.higgins.cardstore.schemas._2005._02.trust.impl;

import org.eclipse.higgins.cardstore.Constants;
import org.eclipse.higgins.cardstore.LocalElementNames;
import org.eclipse.higgins.cardstore.exceptions.ExpectedObjectNotPresent;
import org.eclipse.higgins.cardstore.exceptions.UnsupportedObjectModel;
import org.eclipse.higgins.cardstore.resources.CardStoreMessages;
import org.eclipse.higgins.cardstore.schemas._2005._02.trust.ITokenType;
import org.eclipse.higgins.cardstore.utils.MessageHelper;
import org.eclipse.higgins.cardstore.utils.XmlUtils;
import org.w3c.dom.Element;

public class TokenType implements ITokenType {
	public static String copyright = Constants.FULL_COPYRIGHT;
	
	private String _tokenTypeUri = null;
	
	private Element _tokenTypeElement = null;	

	Object _parentNode = null;
	
	public Object getParent()
	{
		return _parentNode;
	}
	
	public void setParent(Object parentNode)
	{
		_parentNode = parentNode;
	}	
	
	public String getUri() {
		return _tokenTypeUri;
	}

	public void setUri(String tokenTypeUri) {
		_tokenTypeUri = tokenTypeUri;		
	}

	public void fromXml(Object obj) throws UnsupportedObjectModel, ExpectedObjectNotPresent {
		_tokenTypeElement = XmlUtils.retrieveElementFromObject(obj);
		
		if (!XmlUtils.isElementType(
				_tokenTypeElement, 
				LocalElementNames.TRUST_TOKEN_TYPE, 
				Constants.NSURI_TRUST_2005_02) || _tokenTypeElement == null)
		{
			_tokenTypeElement = null;
			throw new ExpectedObjectNotPresent(
					MessageHelper.getMessage(
							CardStoreMessages.expected_object_not_present, 
							new Object[]{Constants.NSURI_TRUST_2005_02 + ":" + LocalElementNames.TRUST_TOKEN_TYPE}));			
			
		}
		
		if (_tokenTypeElement != null)
		{
			String s = XmlUtils.retrieveAllTextFromChildTextNodes(_tokenTypeElement);
			
			if (s != null && s.length() > 0)
			{
				setUri(s);
			}
		}
	}

	public Object toXml() {
		// TODO Auto-generated method stub
		return null;
	}

}
