/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Patrick R Wardrop (IBM Corporation)
 *******************************************************************************/ 
package org.eclipse.higgins.cardstore.schemas._2005._05.identity.impl;

import org.eclipse.higgins.cardstore.Constants;
import org.eclipse.higgins.cardstore.LocalElementNames;
import org.eclipse.higgins.cardstore.exceptions.ExpectedObjectNotPresent;
import org.eclipse.higgins.cardstore.exceptions.UnsupportedObjectModel;
import org.eclipse.higgins.cardstore.resources.CardStoreMessages;
import org.eclipse.higgins.cardstore.schemas._2005._05.identity.IClaimValue;
import org.eclipse.higgins.cardstore.utils.MessageHelper;
import org.eclipse.higgins.cardstore.utils.XmlUtils;
import org.w3c.dom.Element;

public class ClaimValue implements IClaimValue {
	public static String copyright = Constants.FULL_COPYRIGHT;
	
	private String _value = null;
	private String _uri = null;
	private Element _claimValueElement = null;
	
	Object _parentNode = null;
	
	public Object getParent()
	{
		return _parentNode;
	}
	
	public void setParent(Object parentNode)
	{
		_parentNode = parentNode;
	}		
	
	public String getValue() {
		return _value;
	}

	public void setValue(String value) {
		_value = value;
	}

	public String getUri() {
		return _uri;
	}

	public void setUri(String value) {
		_uri = value;
	}

	public void fromXml(Object obj) throws UnsupportedObjectModel,
			ExpectedObjectNotPresent {
		_claimValueElement = XmlUtils.retrieveElementFromObject(obj);
		
		if (!XmlUtils.isElementType(
				_claimValueElement, 
				LocalElementNames.IDENTITY_CLAIM_VALUE, 
				Constants.NSURI_IDENTITY_2005_05) || _claimValueElement == null)
		{
			_claimValueElement = null;
			throw new ExpectedObjectNotPresent(
					MessageHelper.getMessage(
							CardStoreMessages.expected_object_not_present, 
							new Object[]{Constants.NSURI_IDENTITY_2005_05 + ":" + LocalElementNames.IDENTITY_CLAIM_VALUE}));

		}
		
		if (_claimValueElement != null)
		{
			setUri(_claimValueElement.getAttribute("Uri"));
			
			Element valueElement = XmlUtils.retrieveFirstChildMatchOfType(
									_claimValueElement, 
									LocalElementNames.IDENTITY_VALUE, 
									Constants.NSURI_IDENTITY_2005_05);
			if (valueElement != null)
			{
				setValue(XmlUtils.retrieveAllTextFromChildTextNodes(valueElement));
			}
		}

	}

	public Object toXml() {
		// TODO Auto-generated method stub
		return null;
	}

}
