/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.cardstore.logging.impl;

import org.eclipse.higgins.cardstore.logging.Log;

public class LoggerConsoleImpl
implements Log {
    public static String copyright = "Licensed Materials - Property of IBM\n(C) Copyright IBM Corporation 2004, 2005, 2007. All Rights Reserved.\nU.S. Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n";
    private Class _callerClass = null;

    public LoggerConsoleImpl(Class klass) {
        this._callerClass = klass;
    }

    public void enterMethod(String method, Object[] params) {
        String prefix = this._callerClass.getName() + " " + method + " ENTER ";
        StringBuffer sb = new StringBuffer();
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                if (i > 0) {
                    sb.append(" ");
                }
                sb.append(params[i]);
            }
        }
        System.out.println(prefix + "[" + sb.toString() + "]");
    }

    public void enterMethod(String method) {
        String prefix = this._callerClass.getName() + " " + method + " ENTER";
        System.out.println(prefix);
    }

    public void exitMethod(String method, Object result) {
        String prefix = this._callerClass.getName() + " " + method + " RETURN ";
        System.out.println(prefix + "[" + result + "]");
    }

    public void exitMethod(String method) {
        String prefix = this._callerClass.getName() + " " + method + " RETURN";
        System.out.println(prefix);
    }

    public void throwing(String method, Throwable thrown) {
        if (thrown != null) {
            System.out.println("Exception thrown: " + method + ": " + thrown.getMessage());
            thrown.printStackTrace();
        }
    }

    public void debug(Object arg0) {
        System.out.println(arg0);
    }

    public void debug(Object arg0, Throwable arg1) {
        System.out.println(arg0);
        arg1.printStackTrace();
    }

    public void error(Object arg0) {
        System.err.println(arg0);
    }

    public void error(Object arg0, Throwable arg1) {
        System.err.println(arg0);
        arg1.printStackTrace();
    }

    public void fatal(Object arg0) {
        System.err.println(arg0);
    }

    public void fatal(Object arg0, Throwable arg1) {
        System.err.println(arg0);
        arg1.printStackTrace();
    }

    public void info(Object arg0) {
        System.out.println(arg0);
    }

    public void info(Object arg0, Throwable arg1) {
        System.out.println(arg0);
        arg1.printStackTrace();
    }

    public boolean isDebugEnabled() {
        return true;
    }

    public boolean isErrorEnabled() {
        return true;
    }

    public boolean isFatalEnabled() {
        return true;
    }

    public boolean isInfoEnabled() {
        return true;
    }

    public boolean isTraceEnabled() {
        return true;
    }

    public boolean isWarnEnabled() {
        return true;
    }

    public void trace(String method, Object arg0) {
        String prefix = this._callerClass.getName() + " " + method + " ";
        System.out.println(prefix + arg0);
    }

    public void trace(String method, Object arg0, Throwable thrown) {
        String traceMsg = this._callerClass.getName() + " " + method + " " + arg0 + " ";
        if (thrown != null) {
            traceMsg = traceMsg + thrown.getMessage();
        }
        System.out.println(traceMsg);
        thrown.printStackTrace();
    }

    public void warn(Object arg0) {
        System.out.println(arg0);
    }

    public void warn(Object arg0, Throwable arg1) {
        System.out.println(arg0);
        arg1.printStackTrace();
    }
}

