/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.cardstore.manager;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import javax.security.auth.callback.PasswordCallback;
import org.eclipse.higgins.cardstore.CardStoreBuilderFactory;
import org.eclipse.higgins.cardstore.ICardStoreBuilder;
import org.eclipse.higgins.cardstore.logging.Log;
import org.eclipse.higgins.cardstore.logging.LogHelper;
import org.eclipse.higgins.cardstore.manager.Operation;
import org.eclipse.higgins.cardstore.manager.Option;
import org.eclipse.higgins.cardstore.manager.PasswordPrompt;
import org.eclipse.higgins.cardstore.schemas._2005._05.identity.IEncryptedStore;
import org.eclipse.higgins.cardstore.schemas._2005._05.identity.IRoamingInformationCard;
import org.eclipse.higgins.cardstore.schemas._2005._05.identity.IRoamingStore;
import org.eclipse.higgins.cardstore.utils.MessageHelper;

public class ICardManager {
    public static String copyright = "Licensed Materials - Property of IBM\n(C) Copyright IBM Corporation 2004, 2005, 2007. All Rights Reserved.\nU.S. Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n";
    private static final String[] LIST_REQUIRED_OPTIONS = new String[]{"-cardstore"};
    public static final int SUCCESS = 0;
    public static final int FAILURE = 1;
    private static Log _log = LogHelper.getLogger(class$org$eclipse$higgins$cardstore$manager$ICardManager == null ? (class$org$eclipse$higgins$cardstore$manager$ICardManager = ICardManager.class$("org.eclipse.higgins.cardstore.manager.ICardManager")) : class$org$eclipse$higgins$cardstore$manager$ICardManager);
    ICardStoreBuilder builder = CardStoreBuilderFactory.newCardStoreBuilder();
    static /* synthetic */ Class class$org$eclipse$higgins$cardstore$manager$ICardManager;

    public static void main(String[] args) {
        String method = "main";
        _log.enterMethod(method, args);
        int result = 0;
        ICardManager icm = new ICardManager();
        result = icm.invoke(args);
        if (result != 0) {
            ICardManager.usage();
        }
        _log.exitMethod(method, new Integer(result));
        System.exit(result);
    }

    public int invoke(String[] args) {
        String method = "invoke";
        _log.enterMethod(method, args);
        int result = 0;
        Operation operation = this.retrieveAction(args);
        if (operation != null) {
            Option[] options = this.retrieveOptions(args);
            if (operation == Operation.USAGE) {
                ICardManager.usage();
                result = 0;
            } else if (operation == Operation.LIST) {
                result = this.runListOperation(options);
            }
        } else {
            result = 1;
        }
        _log.exitMethod(method, Integer.toString(result));
        return result;
    }

    private int runListOperation(Option[] options) {
        int rc = 1;
        if (options != null && options.length > 0) {
            if (this.isRequiredOptionsPresent(options, LIST_REQUIRED_OPTIONS)) {
                rc = this.isOptionPresent(options, "-cardid") ? this.runListDisplaySpecificCard(options) : this.runListCards(options);
            }
        } else {
            System.err.println(MessageHelper.getMessage("no_supported_options_given", new Object[]{Operation.LIST.getLiterals()[0]}));
        }
        return rc;
    }

    private int runListCards(Option[] options) {
        int rc = 0;
        String cardStoreFilename = this.retrieveOptionValue(options, "-cardstore");
        String cardStorePassword = this.retrieveOptionValue(options, "-cardstorepasswd");
        char[] cardStorePasswordChars = null;
        boolean isVerbose = this.isOptionPresent(options, "-v");
        if (cardStoreFilename == null) {
            System.err.println(MessageHelper.getMessage("required_option_value_not_given", new Object[]{"-cardstore"}));
            rc = 1;
            return rc;
        }
        cardStorePasswordChars = cardStorePassword == null ? this.promptForStorePassword() : cardStorePassword.toCharArray();
        if (cardStorePasswordChars == null || cardStorePasswordChars.length < 1) {
            System.err.println(MessageHelper.getMessage("required_option_value_not_given", new Object[]{"-cardstorepasswd"}));
            rc = 1;
            return rc;
        }
        IRoamingStore roamingStore = this.retrieveRoamingStore(cardStoreFilename, cardStorePasswordChars);
        if (roamingStore == null) {
            return 1;
        }
        IRoamingInformationCard[] cards = roamingStore.getRoamingInformationCards();
        this.displayNumberOfCards(cards);
        return rc;
    }

    private void displayNumberOfCards(IRoamingInformationCard[] cards) {
        System.out.println(MessageHelper.getMessage("card_manager_num_of_cards_in_store", new Object[]{new Integer(cards.length)}));
    }

    private IRoamingStore retrieveRoamingStore(String cardStoreFilename, char[] cardStorePasswordChars) {
        byte[] crdsBytes = this.readInCrdsFile(cardStoreFilename);
        IRoamingStore rs = null;
        if (crdsBytes != null) {
            try {
                IEncryptedStore ec = this.builder.createEncryptedStore(crdsBytes);
                PasswordCallback pc = new PasswordCallback("password", true);
                pc.setPassword(cardStorePasswordChars);
                rs = ec.getRoamingStore(pc);
            }
            catch (Exception e) {
                _log.error(null, e);
                rs = null;
            }
        }
        return rs;
    }

    private byte[] readInCrdsFile(String cardStoreFilename) {
        File crdsFile = new File(cardStoreFilename);
        byte[] crdsBytes = new byte[(int)crdsFile.length()];
        try {
            FileInputStream fis = new FileInputStream(crdsFile);
            fis.read(crdsBytes);
            fis.close();
        }
        catch (Exception e) {
            _log.error(null, e);
            crdsBytes = null;
        }
        return crdsBytes;
    }

    private int runListDisplaySpecificCard(Option[] options) {
        int rc = 0;
        String cardStoreFilename = this.retrieveOptionValue(options, "-cardstore");
        String cardStorePassword = this.retrieveOptionValue(options, "-cardstorepasswd");
        char[] cardStorePasswordChars = null;
        String cardId = this.retrieveOptionValue(options, "-cardid");
        boolean isVerbose = this.isOptionPresent(options, "-v");
        if (cardStoreFilename == null) {
            System.err.println(MessageHelper.getMessage("required_option_value_not_given", new Object[]{"-cardstore"}));
            rc = 1;
            return rc;
        }
        if (cardId == null) {
            System.err.println(MessageHelper.getMessage("required_option_value_not_given", new Object[]{"-cardid"}));
            rc = 1;
            return rc;
        }
        if (cardStorePassword == null) {
            cardStorePasswordChars = this.promptForStorePassword();
        }
        if (cardStorePasswordChars == null || cardStorePasswordChars.length < 1) {
            System.err.println(MessageHelper.getMessage("required_option_value_not_given", new Object[]{"-cardstorepasswd"}));
            rc = 1;
            return rc;
        }
        return rc;
    }

    private char[] promptForStorePassword() {
        try {
            return PasswordPrompt.getPassword(System.in, MessageHelper.getMessage("cardstore_password_prompt", null));
        }
        catch (Exception e) {
            _log.error(null, e);
            return null;
        }
    }

    private Option[] retrieveOptions(String[] args) {
        ArrayList<Option> list = new ArrayList<Option>();
        if (args != null && args.length > 1) {
            for (int i = 1; i < args.length; ++i) {
                if (args[i] == null || !args[i].startsWith("-")) continue;
                String optionName = args[i];
                String optionValue = null;
                if (i + 1 < args.length && args[i + 1] != null && !args[i + 1].startsWith("-")) {
                    optionValue = args[i + 1];
                }
                list.add(new Option(optionName, optionValue));
            }
        }
        return list.toArray(new Option[list.size()]);
    }

    private Operation retrieveAction(String[] args) {
        String operation;
        Operation oper = null;
        if (args == null || args.length < 1) {
            System.err.println(MessageHelper.getMessage("no_operation_given", null));
            ICardManager.usage();
            oper = null;
            return oper;
        }
        if (args != null && args.length > 0 && (operation = args[0]) != null) {
            if (!operation.startsWith("-")) {
                System.err.println(MessageHelper.getMessage("no_operation_given", null));
                ICardManager.usage();
                oper = null;
                return oper;
            }
            oper = Operation.fromString(operation);
            if (oper == null) {
                System.err.println(MessageHelper.getMessage("no_supported_operation_given", null));
                ICardManager.usage();
            }
        }
        return oper;
    }

    private boolean isOptionPresent(Option[] options, String optionCheck) {
        if (options == null || optionCheck == null) {
            return true;
        }
        for (int i = 0; i < options.length; ++i) {
            if (!optionCheck.equals(options[i].getName())) continue;
            return true;
        }
        return false;
    }

    private String retrieveOptionValue(Option[] options, String optionName) {
        if (options == null || optionName == null) {
            return null;
        }
        for (int i = 0; i < options.length; ++i) {
            if (!optionName.equals(options[i].getName())) continue;
            return options[i].getValue();
        }
        return null;
    }

    private boolean isRequiredOptionsPresent(Option[] givenOptions, String[] requiredOptions) {
        boolean result = false;
        if (requiredOptions == null || requiredOptions.length < 1) {
            result = true;
            return result;
        }
        for (int i = 0; i < requiredOptions.length; ++i) {
            if (!this.isOptionPresent(givenOptions, requiredOptions[i])) {
                result = false;
                break;
            }
            result = true;
        }
        return result;
    }

    private static void usage() {
        System.out.println(MessageHelper.getMessage("card_manager_usage", new Object[]{(class$org$eclipse$higgins$cardstore$manager$ICardManager == null ? (class$org$eclipse$higgins$cardstore$manager$ICardManager = ICardManager.class$("org.eclipse.higgins.cardstore.manager.ICardManager")) : class$org$eclipse$higgins$cardstore$manager$ICardManager).getName()}));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

