/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.cardstore.schemas._2005._05.identity.impl;

import org.eclipse.higgins.cardstore.exceptions.ExpectedObjectNotPresent;
import org.eclipse.higgins.cardstore.exceptions.UnsupportedObjectModel;
import org.eclipse.higgins.cardstore.schemas._2005._05.identity.IClaimValue;
import org.eclipse.higgins.cardstore.schemas._2005._05.identity.IInformationCardPrivateData;
import org.eclipse.higgins.cardstore.schemas._2005._05.identity.impl.ClaimValue;
import org.eclipse.higgins.cardstore.utils.Base64Utility;
import org.eclipse.higgins.cardstore.utils.MessageHelper;
import org.eclipse.higgins.cardstore.utils.XmlUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class InformationCardPrivateData
implements IInformationCardPrivateData {
    public static String copyright = "Licensed Materials - Property of IBM\n(C) Copyright IBM Corporation 2004, 2005, 2007. All Rights Reserved.\nU.S. Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n";
    private Element _cardPrivateDataElement = null;
    private byte[] _masterKeyBytes = null;
    private IClaimValue[] _claimValues = null;
    Object _parentNode = null;

    public Object getParent() {
        return this._parentNode;
    }

    public void setParent(Object parentNode) {
        this._parentNode = parentNode;
    }

    public IClaimValue[] getClaimValueList() {
        return this._claimValues;
    }

    public byte[] getMasterKey() {
        return this._masterKeyBytes;
    }

    public void setClaimValueList(IClaimValue[] claimList) {
        this._claimValues = claimList;
    }

    public void setMasterKey(byte[] value) {
        this._masterKeyBytes = value;
    }

    public void fromXml(Object obj) throws UnsupportedObjectModel, ExpectedObjectNotPresent {
        Element claimValueList;
        String base64EncodedMasterKey;
        this._cardPrivateDataElement = XmlUtils.retrieveElementFromObject(obj);
        if (!XmlUtils.isElementType(this._cardPrivateDataElement, "InformationCardPrivateData", "http://schemas.xmlsoap.org/ws/2005/05/identity") || this._cardPrivateDataElement == null) {
            this._cardPrivateDataElement = null;
            throw new ExpectedObjectNotPresent(MessageHelper.getMessage("expected_object_not_present", new Object[]{"http://schemas.xmlsoap.org/ws/2005/05/identity:InformationCardPrivateData"}));
        }
        Element masterKeyElement = XmlUtils.retrieveFirstChildMatchOfType(this._cardPrivateDataElement, "MasterKey", "http://schemas.xmlsoap.org/ws/2005/05/identity");
        if (masterKeyElement != null && (base64EncodedMasterKey = XmlUtils.retrieveAllTextFromChildTextNodes(masterKeyElement)) != null) {
            this.setMasterKey(Base64Utility.decode(base64EncodedMasterKey));
        }
        if ((claimValueList = XmlUtils.retrieveFirstChildMatchOfType(this._cardPrivateDataElement, "ClaimValueList", "http://schemas.xmlsoap.org/ws/2005/05/identity")) != null) {
            this._claimValues = new ClaimValue[XmlUtils.numberOfChildElementsOfType(claimValueList, "ClaimValue", "http://schemas.xmlsoap.org/ws/2005/05/identity")];
            int numClaimValues = 0;
            NodeList nl = claimValueList.getChildNodes();
            int len = nl.getLength();
            for (int i = 0; i < len; ++i) {
                Node n = nl.item(i);
                if (XmlUtils.isElementType((Element)n, "ClaimValue", "http://schemas.xmlsoap.org/ws/2005/05/identity")) {
                    // empty if block
                }
                this._claimValues[numClaimValues] = new ClaimValue();
                this._claimValues[numClaimValues].fromXml(n);
                ((ClaimValue)this._claimValues[numClaimValues]).setParent(this);
                ++numClaimValues;
            }
        }
    }

    public Object toXml() {
        return this._cardPrivateDataElement;
    }
}

