/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.cardstore.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import javax.security.auth.callback.PasswordCallback;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.eclipse.higgins.cardstore.CardStoreBuilderFactory;
import org.eclipse.higgins.cardstore.ICardStoreBuilder;
import org.eclipse.higgins.cardstore.exceptions.StoreEncryptionException;
import org.eclipse.higgins.cardstore.schemas._2005._05.identity.IEncryptedStore;
import org.eclipse.higgins.cardstore.schemas._2005._05.identity.IRoamingStore;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Tester {
    public static void main(String[] args) throws Exception {
        char[] passwd = new char[]{'p', 'a', 's', 's', 'w', '0', 'r', 'd'};
        IRoamingStore mycards = Tester.readInStore("/home/bus/bas/empty.crds", passwd);
        File roamingStoreXml = new File("/home/bus/bas/cardmanagerExport230707Good.xml");
        StringBuffer xmlSz = new StringBuffer();
        try {
            int car;
            FileReader reader = new FileReader(roamingStoreXml);
            while ((car = reader.read()) != -1) {
                xmlSz.append((char)car);
            }
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        OMElement om0 = Tester.toOM(xmlSz.toString());
        Element element = Tester.toDOM(om0);
        mycards.fromXml(element);
        String out = "/home/bus/bas/new.crds";
        Tester.writeOutStore(mycards, out, passwd);
        System.out.println("Output file: " + out + " created.");
    }

    private static void writeOutStore(IRoamingStore store, String filename, char[] passwd) throws StoreEncryptionException, IOException {
        ICardStoreBuilder builder = CardStoreBuilderFactory.newCardStoreBuilder();
        IEncryptedStore es = builder.createEncryptedStore();
        es.setRoamingStore(store);
        PasswordCallback pc = new PasswordCallback("What is your password: ", true);
        pc.setPassword(passwd);
        long timeStart = System.currentTimeMillis();
        byte[] esBytes = es.toXml(pc);
        long timeStop = System.currentTimeMillis();
        System.out.println("total time (encrypt): [" + filename + "]" + (timeStop - timeStart));
        FileOutputStream fos = new FileOutputStream(new File(filename));
        fos.write(esBytes);
        fos.flush();
        fos.close();
    }

    private static IRoamingStore readInStore(String filename, char[] passwd) throws Exception {
        ICardStoreBuilder builder = CardStoreBuilderFactory.newCardStoreBuilder();
        IEncryptedStore es = null;
        PasswordCallback pc = new PasswordCallback("What is your password: ", true);
        pc.setPassword(passwd);
        File crdsFile = new File(filename);
        byte[] crdsBytes = new byte[(int)crdsFile.length()];
        FileInputStream fis = new FileInputStream(crdsFile);
        fis.read(crdsBytes);
        long timeStart = System.currentTimeMillis();
        es = builder.createEncryptedStore(crdsBytes);
        IRoamingStore rs = es.getRoamingStore(pc);
        long timeStop = System.currentTimeMillis();
        System.out.println("total time (decrypt): [" + filename + "]" + (timeStop - timeStart));
        return rs;
    }

    public static Element toDOM(OMElement omElement) throws Exception {
        if (omElement == null) {
            return null;
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            omElement.serialize((OutputStream)outputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (outputStream.size() == 0) {
            return null;
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document domDocument = documentBuilder.parse(inputStream);
        return domDocument.getDocumentElement();
    }

    public static OMElement toOM(String strElement) throws Exception {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(strElement.getBytes());
        XMLInputFactory xif = XMLInputFactory.newInstance();
        XMLStreamReader reader = xif.createXMLStreamReader(inputStream);
        StAXOMBuilder builder = new StAXOMBuilder(reader);
        return builder.getDocumentElement();
    }
}

