/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Patrick R Wardrop (IBM Corporation)
 *******************************************************************************/ 
package org.eclipse.higgins.cardstore.schemas._2005._05.identity.impl;

import org.eclipse.higgins.cardstore.Constants;
import org.eclipse.higgins.cardstore.LocalElementNames;
import org.eclipse.higgins.cardstore.exceptions.ExpectedObjectNotPresent;
import org.eclipse.higgins.cardstore.exceptions.UnsupportedObjectModel;
import org.eclipse.higgins.cardstore.resources.CardStoreMessages;
import org.eclipse.higgins.cardstore.schemas._2005._05.identity.ISupportedClaimType;
import org.eclipse.higgins.cardstore.utils.MessageHelper;
import org.eclipse.higgins.cardstore.utils.XmlUtils;
import org.w3c.dom.Element;

public class SupportedClaimType implements ISupportedClaimType {
	public static String copyright = Constants.FULL_COPYRIGHT;
	
	private Element _supportedClaimElement = null;
	
	private String _uri = null;
	
	private String _description = null;
	
	private String _displayTag = null;

	Object _parentNode = null;
	
	public Object getParent()
	{
		return _parentNode;
	}
	
	public void setParent(Object parentNode)
	{
		_parentNode = parentNode;
	}	
	
	
	public String getDescription() {		
		return _description;
	}

	public String getDisplayTag() {
		return _displayTag;
	}

	public void setDescription(String value) {
		_description = value;		
	}

	public void setDisplayTag(String value) {
		_displayTag = value;
	}

	public String getUri() {
		return _uri;
	}

	public void setUri(String value) {
		_uri = value;		
	}

	public void fromXml(Object obj) throws UnsupportedObjectModel, ExpectedObjectNotPresent {
		_supportedClaimElement = XmlUtils.retrieveElementFromObject(obj);
		
		if (!XmlUtils.isElementType(
				_supportedClaimElement, 
				LocalElementNames.IDENTITY_SUPPORTED_CLAIM_TYPE, 
				Constants.NSURI_IDENTITY_2005_05) || _supportedClaimElement == null)
		{
			_supportedClaimElement = null;

			throw new ExpectedObjectNotPresent(
					MessageHelper.getMessage(
							CardStoreMessages.expected_object_not_present, 
							new Object[]{Constants.NSURI_IDENTITY_2005_05 + ":" + LocalElementNames.IDENTITY_SUPPORTED_CLAIM_TYPE}));			
		}
		
		if (_supportedClaimElement != null)
		{
			setUri(_supportedClaimElement.getAttribute("Uri"));
			
			Element displayTagElement = XmlUtils.retrieveFirstChildMatchOfType(
					_supportedClaimElement, 
									LocalElementNames.IDENTITY_DISPLAY_TAG, 
									Constants.NSURI_IDENTITY_2005_05);
			if (displayTagElement != null)
			{
				setDisplayTag(XmlUtils.retrieveAllTextFromChildTextNodes(displayTagElement));
			}
			
			Element descriptionElement = XmlUtils.retrieveFirstChildMatchOfType(
					_supportedClaimElement, 
									LocalElementNames.IDENTITY_DESCRIPTION, 
									Constants.NSURI_IDENTITY_2005_05);
			if (descriptionElement != null)
			{
				setDescription(XmlUtils.retrieveAllTextFromChildTextNodes(descriptionElement));
			}			
		}
	}


	public Object toXml() {
		// TODO Auto-generated method stub
		return null;
	}

}
