/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Patrick R Wardrop (IBM Corporation)
 *******************************************************************************/ 
package org.eclipse.higgins.cardstore.schemas._2005._05.identity;

import java.util.Date;
import java.util.Locale;

import org.eclipse.higgins.cardstore.Constants;
import org.eclipse.higgins.cardstore.schemas.XMLSerializer;
import org.eclipse.higgins.cardstore.schemas._2005._02.trust.ITokenType;

public interface IInformationCard extends XMLSerializer {
	public static String copyright = Constants.FULL_COPYRIGHT;
	
	IInformationCardReference getInformationCardReference();

	void setInformationCardReference(IInformationCardReference value);

	String getCardName();

	void setCardName(String value);

	ICardImage getCardImage();

	void setCardImage(ICardImage value);

	String getIssuer();

	void setIssuer(String value);

	Date getTimeIssued();

	void setTimeIssued(Date timeIssued);

	Date getTimeExpires();

	void setTimeExpires(Date timeExpires);

	ITokenService[] getTokenServiceList();

	void setTokenServiceList(ITokenService[] value);

	ITokenType[] getSupportedTokenTypeList();

	void setSupportedTokenTypeList(ITokenType[] value);

	ISupportedClaimType[] getSupportedClaimTypeList();

	void setSupportedClaimTypeList(ISupportedClaimType[] value);

	IRequireAppliesTo getRequireAppliesTo();

	void setRequireAppliesTo(IRequireAppliesTo value);

	IPrivacyNoticeLocation getPrivacyNotice();

	void setPrivacyNotice(IPrivacyNoticeLocation value);

	Locale getLang();

	void setLang(Locale locale);

}