/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Patrick R Wardrop (IBM Corporation)
 *******************************************************************************/ 
package org.eclipse.higgins.cardstore.schemas._2005._05.identity.impl;

import org.eclipse.higgins.cardstore.Constants;
import org.eclipse.higgins.cardstore.LocalElementNames;
import org.eclipse.higgins.cardstore.exceptions.ExpectedObjectNotPresent;
import org.eclipse.higgins.cardstore.exceptions.UnsupportedObjectModel;
import org.eclipse.higgins.cardstore.resources.CardStoreMessages;
import org.eclipse.higgins.cardstore.schemas._2005._05.identity.IRequireAppliesTo;
import org.eclipse.higgins.cardstore.utils.MessageHelper;
import org.eclipse.higgins.cardstore.utils.XmlUtils;
import org.w3c.dom.Element;

public class RequireAppliesTo implements IRequireAppliesTo {
	public static String copyright = Constants.FULL_COPYRIGHT;
	
	private Element _requireAppliesToElement = null;
		
	private boolean _isOptional = false;
	
	private boolean _isOptionalSet = false;
	
	Object _parentNode = null;
	
	public Object getParent()
	{
		return _parentNode;
	}
	
	public void setParent(Object parentNode)
	{
		_parentNode = parentNode;
	}	
	
	
	public boolean isOptional() {
		return _isOptional;
	}

	public boolean isSetOptional() {
		return _isOptionalSet;
	}

	public void setOptional(boolean value) {
		_isOptional = value;
		_isOptionalSet = true;
	}

	public void unsetOptional() {
		_isOptional = false;
		_isOptionalSet = false;
	}

	public void fromXml(Object obj) throws UnsupportedObjectModel,
			ExpectedObjectNotPresent {
		_requireAppliesToElement = XmlUtils.retrieveElementFromObject(obj);
		
		if (!XmlUtils.isElementType(
				_requireAppliesToElement, 
				LocalElementNames.IDENTITY_REQUIRE_APPLIES_TO, 
				Constants.NSURI_IDENTITY_2005_05) || _requireAppliesToElement == null)
		{
			_requireAppliesToElement = null;

			throw new ExpectedObjectNotPresent(
					MessageHelper.getMessage(
							CardStoreMessages.expected_object_not_present, 
							new Object[]{Constants.NSURI_IDENTITY_2005_05 + ":" + LocalElementNames.IDENTITY_REQUIRE_APPLIES_TO}));
			
		}
		
		String s = _requireAppliesToElement.getAttribute("Optional");
		
		if (s != null && s.length() > 0)
		{
			setOptional(Boolean.valueOf(s).booleanValue());
		}
	}

	public Object toXml() {
		// TODO Auto-generated method stub
		return null;
	}

}
