/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Patrick R Wardrop (IBM Corporation)
 *******************************************************************************/ 

package org.eclipse.higgins.cardstore.schemas._2005._05.identity;

import javax.security.auth.callback.PasswordCallback;

import org.eclipse.higgins.cardstore.Constants;
import org.eclipse.higgins.cardstore.exceptions.StoreDecryptionException;
import org.eclipse.higgins.cardstore.exceptions.StoreEncryptionException;
import org.eclipse.higgins.cardstore.schemas.XMLSerializer;


/**
 * This interface presents a encrypted CRDS (Card Space card store). CRDS
 * files are typically exported from a CardSpace implementation. They are
 * encrypted with a key derived from a user supplied password.
 * <p/>
 * The XML schema can be found at:
 * http://schemas.xmlsoap.org/ws/2005/05/identity
 * 
 * @author pwardrop
 *
 */
public interface IEncryptedStore extends XMLSerializer{
	
	public static String copyright = Constants.FULL_COPYRIGHT;
	
	/**
	 * This method will return the store salt.  
	 * 
	 * @return byte array of store salt.  The value will be Base64 decoded.
	 */
	public byte[] getStoreSalt();
		
	/**
	 * Returns the the byte order marker for the CRDS file. 
	 * <p/>
	 * The typical values are:
	 * <code>{0xEF, 0xBB, 0xBF}</code>.
	 * <p/>
	 * 
	 * @return three bytes; null if no byte order marker is present.
	 */
	public byte[] getByteOrderMark();
	
	/**
	 * This method is used to replace or add a roaming store that the encrypted store is based on.
	 * 
	 * @param roamingStore
	 */
	public void setRoamingStore(IRoamingStore roamingStore);
	
	/**
	 * Returns a RoamingStore object.
	 * 
	 * @param passwdCallback the required password to decrypt the store.
	 * @return
	 */
	public IRoamingStore getRoamingStore(PasswordCallback passwdCallback) throws StoreDecryptionException;
	
	/**
	 * Returns a EncryptedStore XML object encrypted using the provided password.
	 * 
	 * @param passwdCallback
	 * @return
	 * @throws StoreEncryptionException
	 */
	public byte[] toXml(PasswordCallback passwdCallback) throws StoreEncryptionException;
}
