/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Patrick R Wardrop (IBM Corporation)
 *******************************************************************************/
package org.eclipse.higgins.cardstore.schemas._2005._05.identity.impl;

import org.eclipse.higgins.cardstore.Constants;
import org.eclipse.higgins.cardstore.LocalElementNames;
import org.eclipse.higgins.cardstore.exceptions.ExpectedObjectNotPresent;
import org.eclipse.higgins.cardstore.exceptions.UnsupportedObjectModel;
import org.eclipse.higgins.cardstore.resources.CardStoreMessages;
import org.eclipse.higgins.cardstore.schemas._2005._05.identity.IClaimValue;
import org.eclipse.higgins.cardstore.schemas._2005._05.identity.IInformationCardPrivateData;
import org.eclipse.higgins.cardstore.utils.Base64Utility;
import org.eclipse.higgins.cardstore.utils.MessageHelper;
import org.eclipse.higgins.cardstore.utils.XmlUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class InformationCardPrivateData implements IInformationCardPrivateData {
    public static String copyright = Constants.FULL_COPYRIGHT;

    private Element _cardPrivateDataElement = null;

    private byte[] _masterKeyBytes = null;

    private IClaimValue[] _claimValues = null;

    Object _parentNode = null;

    public Object getParent() {
	return _parentNode;
    }

    public void setParent(Object parentNode) {
	_parentNode = parentNode;
    }

    public IClaimValue[] getClaimValueList() {
	return _claimValues;
    }

    public byte[] getMasterKey() {
	return _masterKeyBytes;
    }

    public void setClaimValueList(IClaimValue[] claimList) {
	_claimValues = claimList;
    }

    public void setMasterKey(byte[] value) {
	_masterKeyBytes = value;
    }

    public void fromXml(Object obj) throws UnsupportedObjectModel,
	    ExpectedObjectNotPresent {

	_cardPrivateDataElement = XmlUtils.retrieveElementFromObject(obj);

	if (!XmlUtils.isElementType(_cardPrivateDataElement,
		LocalElementNames.IDENTITY_INFORMATION_CARD_PRIVATE_DATA,
		Constants.NSURI_IDENTITY_2005_05)
		|| _cardPrivateDataElement == null) {
	    _cardPrivateDataElement = null;
	    throw new ExpectedObjectNotPresent(
		    MessageHelper
			    .getMessage(
				    CardStoreMessages.expected_object_not_present,
				    new Object[] { Constants.NSURI_IDENTITY_2005_05
					    + ":"
					    + LocalElementNames.IDENTITY_INFORMATION_CARD_PRIVATE_DATA }));

	}

	Element masterKeyElement = XmlUtils.retrieveFirstChildMatchOfType(
		_cardPrivateDataElement, LocalElementNames.IDENTITY_MASTER_KEY,
		Constants.NSURI_IDENTITY_2005_05);

	if (masterKeyElement != null) {
	    String base64EncodedMasterKey = XmlUtils
		    .retrieveAllTextFromChildTextNodes(masterKeyElement);

	    if (base64EncodedMasterKey != null) {
		setMasterKey(Base64Utility.decode(base64EncodedMasterKey));
	    }
	}

	Element claimValueList = XmlUtils.retrieveFirstChildMatchOfType(
		_cardPrivateDataElement,
		LocalElementNames.IDENTITY_CLAIM_VALUE_LIST,
		Constants.NSURI_IDENTITY_2005_05);

	if (claimValueList != null) {
	    _claimValues = new ClaimValue[XmlUtils.numberOfChildElementsOfType(
		    claimValueList, LocalElementNames.IDENTITY_CLAIM_VALUE,
		    Constants.NSURI_IDENTITY_2005_05)];
	    int numClaimValues = 0;

	    NodeList nl = claimValueList.getChildNodes();
	    int len = nl.getLength();

	    for (int i = 0; i < len; i++) {
		Node n = nl.item(i);

		if (XmlUtils.isElementType((Element) n,
			LocalElementNames.IDENTITY_CLAIM_VALUE,
			Constants.NSURI_IDENTITY_2005_05))
		    ;
		{
		    _claimValues[numClaimValues] = new ClaimValue();
		    _claimValues[numClaimValues].fromXml(n);
		    ((ClaimValue) _claimValues[numClaimValues]).setParent(this);
		    numClaimValues++;
		}
	    }
	}
    }

    public Object toXml() {
	return _cardPrivateDataElement;
    }

}
