/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Patrick R Wardrop (IBM Corporation)
 *******************************************************************************/ 
package org.eclipse.higgins.cardstore.utils;

import java.text.MessageFormat;
import java.util.ResourceBundle;

import org.eclipse.higgins.cardstore.Constants;
import org.eclipse.higgins.cardstore.resources.CardStoreMessages;

public class MessageHelper {
	public static String copyright = Constants.FULL_COPYRIGHT;
	
	private final static ResourceBundle bundle = ResourceBundle.getBundle(CardStoreMessages.class.getName());
	
	public static String getMessage(String key, Object[] replacements)
	{
		String result = null;
		
		String message = bundle.getString(key);
		
		if (replacements != null && replacements.length > 0)
		{
			result = MessageFormat.format(message, replacements);
		} else {
			result = message;
		}
		
		return result;
	}

}
