/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Patrick R Wardrop (IBM Corporation)
 *******************************************************************************/ 
package org.eclipse.higgins.cardstore;

import org.eclipse.higgins.cardstore.exceptions.ExpectedObjectNotPresent;
import org.eclipse.higgins.cardstore.exceptions.UnsupportedObjectModel;
import org.eclipse.higgins.cardstore.schemas._2000._09.xmldsig.IKeyInfo;
import org.eclipse.higgins.cardstore.schemas._2000._09.xmldsig.IX509Data;
import org.eclipse.higgins.cardstore.schemas._2000._09.xmldsig.impl.KeyInfo;
import org.eclipse.higgins.cardstore.schemas._2000._09.xmldsig.impl.X509Data;
import org.eclipse.higgins.cardstore.schemas._2005._02.trust.ITokenType;
import org.eclipse.higgins.cardstore.schemas._2005._02.trust.impl.TokenType;
import org.eclipse.higgins.cardstore.schemas._2005._05.identity.*;
import org.eclipse.higgins.cardstore.schemas._2005._05.identity.impl.*;
import org.eclipse.higgins.cardstore.schemas._2005._08.addressing.IEndpointReference;
import org.eclipse.higgins.cardstore.schemas._2005._08.addressing.IMetaData;
import org.eclipse.higgins.cardstore.schemas._2005._08.addressing.impl.EndpointReference;
import org.eclipse.higgins.cardstore.schemas._2005._08.addressing.impl.MetaData;
import org.eclipse.higgins.cardstore.schemas._2006._02.addressingidentity.IIdentity;
import org.eclipse.higgins.cardstore.schemas._2006._02.addressingidentity.impl.Identity;

public class CardStoreDomBuilder implements ICardStoreBuilder {
	public static String copyright = Constants.FULL_COPYRIGHT;
	
	protected CardStoreDomBuilder()
	{
		
	}
	
	public IEncryptedStore createEncryptedStore(byte[] crdsBytes) throws UnsupportedObjectModel, ExpectedObjectNotPresent
	{
		return new EncryptedStore(crdsBytes);
	}

	public IEncryptedStore createEncryptedStore()
	{
		return new EncryptedStore();
	}
		
	public ICardImage createCardImage()
	{
		return new CardImage();
	}
	
	public IClaimValue createClaimValue()
	{
		return new ClaimValue();
	}

	public IInformationCardMetaData createInformationCardMetaData()
	{
		return new InformationCardMetaData();
	}

	public IInformationCardPrivateData createInformationCardPrivateData()
	{
		return new InformationCardPrivateData();
	}

	public IInformationCardReference createInformationCardReference()
	{
		return new InformationCardReference();
	}
	
	public IPrivacyNoticeLocation createPrivacyNoticeLocation()
	{
		return new PrivacyNoticeLocation();
	}
	
	public IRequireAppliesTo createRequireAppliesTo()
	{
		return new RequireAppliesTo();
	}
	
	public IRoamingInformationCard createRoamingInformationCard()
	{
		return new RoamingInformationCard();
	}
	
	public ISelfIssuedCredential createSelfIssuedCredential()
	{
		return new SelfIssedCredential();
	}
	
	public ISupportedClaimType createSupportedClaimType()
	{
		return new SupportedClaimType();
	}
	
	public ITokenService createTokenService()
	{
		return new TokenService();
	}
	
	public IUserCredential createUserCredential()
	{
		return new UserCredential();
	}

	public IUsernamePasswordCredential createUsernamePasswordCredential()
	{
		return new UsernamePasswordCredential();
	}

	public IX509V3Credential createX509V3Credential()
	{
		return new X509V3Credential();
	}
	
	public IKeyInfo createKeyInfo()
	{
		return new KeyInfo();
	}
	
	public IX509Data createX509Data()
	{
		return new X509Data();
	}
	
	public ITokenType createTokenType()
	{
		return new TokenType();
	}
	
	public IEndpointReference createEndpointReference()
	{
		return new EndpointReference();
	}
	
	public IMetaData createMetaData()
	{
		return new MetaData();
	}
	
	public IIdentity createIdentity()
	{
		return new Identity();
	}
}
