/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Patrick R Wardrop (IBM Corporation)
 *******************************************************************************/ 
package org.eclipse.higgins.cardstore.manager;

public class Operation {
	private final static int LIST_OPERATION = 0;
	private final static int USAGE_OPERATION = 0; 
	
	public final static Operation USAGE = new Operation(USAGE_OPERATION, new String[]{"-help","-h","-usage"});
	
	public final static Operation LIST = new Operation(LIST_OPERATION, new String[]{"-list","-l"});
	
	public static Operation[] SUPPORTED_OPERATIONS = null;
	
	static {
		SUPPORTED_OPERATIONS = new Operation[2];
		SUPPORTED_OPERATIONS[0] = USAGE;
		SUPPORTED_OPERATIONS[1] = LIST;
	}
	
	private String[] _literals = null;
	
	private Operation(int type, String[] literals)
	{
		_literals = literals;
	}
	
	public static Operation fromString(String operation)
	{
		Operation oper = null;
		
		for(int i = 0; i < SUPPORTED_OPERATIONS.length; i++)
		{
			String[] literals = SUPPORTED_OPERATIONS[i].getLiterals();
			
			for(int x = 0; x < literals.length; x++)
			{
				if (operation.equals(literals[x]))
				{
					oper = SUPPORTED_OPERATIONS[i];
					break;
				}
			}
		}
		
		return oper;
	}
	
	public String[] getLiterals()
	{
		return _literals;
	}

}
