/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Patrick R Wardrop (IBM Corporation)
 *******************************************************************************/ 
package org.eclipse.higgins.cardstore.schemas._2005._05.identity;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.higgins.cardstore.Constants;

public final class ILogoImage {
	public static String copyright = Constants.FULL_COPYRIGHT;
	
	public static final int IMAGE_JPEG_TYPE = 0;

	public static final int IMAGE_GIF_TYPE = 1;

	public static final int IMAGE_BMP_TYPE = 2;

	public static final int IMAGE_PNG_TYPE = 3;

	public static final int IMAGE_TIFF_TYPE = 4;

	public static final ILogoImage IMAGE_JPEG = new ILogoImage("image/jpeg");

	public static final ILogoImage IMAGE_GIF = new ILogoImage("image/gif");

	public static final ILogoImage IMAGE_BMP = new ILogoImage("image/bmp");

	public static final ILogoImage IMAGE_PNG = new ILogoImage("image/png");

	public static final ILogoImage IMAGE_TIFF = new ILogoImage("image/tiff");

	private static final ILogoImage[] VALUES_ARRAY =
		new ILogoImage[] {
			IMAGE_JPEG,
			IMAGE_GIF,
			IMAGE_BMP,
			IMAGE_PNG,
			IMAGE_TIFF,
		};

	public static final List VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	private String _literal = null;
	
	public static ILogoImage getByLiteral(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			ILogoImage result = VALUES_ARRAY[i];
			if (result.getLiteral().equals(literal)) {
				return result;
			}
		}
		return null;
	}

	public static ILogoImage get(int value) {
		switch (value) {
			case IMAGE_JPEG_TYPE: return IMAGE_JPEG;
			case IMAGE_GIF_TYPE: return IMAGE_GIF;
			case IMAGE_BMP_TYPE: return IMAGE_BMP;
			case IMAGE_PNG_TYPE: return IMAGE_PNG;
			case IMAGE_TIFF_TYPE: return IMAGE_TIFF;
		}
		return null;	
	}

	private ILogoImage(String literal) {
		_literal = literal;
	}
	
	public String getLiteral()
	{
		return _literal;
	}

}
