/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.cardstore.logging.impl;

import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.cardstore.logging.Log;

public class LoggerApacheCommonsImpl
implements Log {
    public static String copyright = "Licensed Materials - Property of IBM\n(C) Copyright IBM Corporation 2004, 2005, 2007. All Rights Reserved.\nU.S. Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n";
    private org.apache.commons.logging.Log _log = null;
    private Class _callerClass = null;

    public LoggerApacheCommonsImpl(Class klass) {
        this._log = LogFactory.getLog((Class)klass);
        this._callerClass = klass;
    }

    public void enterMethod(String method, Object[] params) {
        String prefix = String.valueOf(this._callerClass.getName()) + " " + method + " ENTER ";
        StringBuffer sb = new StringBuffer();
        if (params != null) {
            int i = 0;
            while (i < params.length) {
                if (i > 0) {
                    sb.append(" ");
                }
                sb.append(params[i]);
                ++i;
            }
        }
        this._log.trace((Object)(String.valueOf(prefix) + "[" + sb.toString() + "]"));
    }

    public void enterMethod(String method) {
        String prefix = String.valueOf(this._callerClass.getName()) + " " + method + " ENTER";
        this._log.trace((Object)prefix);
    }

    public void exitMethod(String method, Object result) {
        String prefix = String.valueOf(this._callerClass.getName()) + " " + method + " RETURN ";
        this._log.trace((Object)(String.valueOf(prefix) + "[" + result + "]"));
    }

    public void exitMethod(String method) {
        String prefix = String.valueOf(this._callerClass.getName()) + " " + method + " RETURN";
        this._log.trace((Object)prefix);
    }

    public void throwing(String method, Throwable thrown) {
        if (thrown != null) {
            this._log.trace((Object)("Exception thrown: " + method + ": " + thrown.getMessage()));
            thrown.printStackTrace();
        }
    }

    public void debug(Object arg0) {
        this._log.debug(arg0);
    }

    public void debug(Object arg0, Throwable arg1) {
        this._log.debug(arg0, arg1);
    }

    public void error(Object arg0) {
        this._log.error(arg0);
    }

    public void error(Object arg0, Throwable arg1) {
        this._log.error(arg0, arg1);
    }

    public void fatal(Object arg0) {
        this._log.fatal(arg0);
    }

    public void fatal(Object arg0, Throwable arg1) {
        this._log.fatal(arg0, arg1);
    }

    public void info(Object arg0) {
        this._log.info(arg0);
    }

    public void info(Object arg0, Throwable arg1) {
        this._log.info(arg0, arg1);
    }

    public boolean isDebugEnabled() {
        return this._log.isDebugEnabled();
    }

    public boolean isErrorEnabled() {
        return this._log.isErrorEnabled();
    }

    public boolean isFatalEnabled() {
        return this._log.isFatalEnabled();
    }

    public boolean isInfoEnabled() {
        return this._log.isInfoEnabled();
    }

    public boolean isTraceEnabled() {
        return this._log.isTraceEnabled();
    }

    public boolean isWarnEnabled() {
        return this._log.isWarnEnabled();
    }

    public void trace(String method, Object arg0) {
        String prefix = String.valueOf(this._callerClass.getName()) + " " + method + " ";
        this._log.trace((Object)(String.valueOf(prefix) + arg0));
    }

    public void trace(String method, Object arg0, Throwable thrown) {
        String traceMsg = String.valueOf(this._callerClass.getName()) + " " + method + " " + arg0 + " ";
        if (thrown != null) {
            traceMsg = String.valueOf(traceMsg) + thrown.getMessage();
        }
        this._log.trace((Object)traceMsg, thrown);
    }

    public void warn(Object arg0) {
        this._log.warn(arg0);
    }

    public void warn(Object arg0, Throwable arg1) {
        this._log.warn(arg0, arg1);
    }
}

