/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.provider.securestorage;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.eclipse.higgins.cardstore.utils.Base64Utility;
import org.eclipse.higgins.icard.AuthenticationException;
import org.eclipse.higgins.icard.AuthenticationRequiredException;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.ICardProvider;
import org.eclipse.higgins.icard.IClaim;
import org.eclipse.higgins.icard.IInformationCardExtension;
import org.eclipse.higgins.icard.InvalidClaimException;
import org.eclipse.higgins.icard.InvalidStateException;
import org.eclipse.higgins.icard.InvalidTypeException;
import org.eclipse.higgins.icard.ReadOnlyObjectException;
import org.eclipse.higgins.icard.auth.ICredential;
import org.eclipse.higgins.icard.auth.IPinCodeCredential;
import org.eclipse.higgins.icard.common.ClaimValue;
import org.eclipse.higgins.icard.io.IElement;
import org.eclipse.higgins.icard.provider.cardspace.common.PersonalCard;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CardStorePersonalCard
extends PersonalCard {
    public CardStorePersonalCard() throws IOException, Exception {
        this.description_ = "CardStore CardSpace-interoperable personal I-Card";
        this.provider_ = null;
        this.isSelfIssued_ = true;
        this.issuer_ = ISSUER_SELF;
        this.issuerName_ = "Self";
    }

    public CardStorePersonalCard(CardStorePersonalCard card2copy) {
        this.id_ = card2copy.id_;
        this.name_ = card2copy.name_;
        this.image_ = card2copy.image_;
        this.imageMimeType_ = card2copy.imageMimeType_;
        this.description_ = card2copy.description_;
        this.provider_ = card2copy.provider_;
        this.isSelfIssued_ = card2copy.isSelfIssued_;
        this.issuer_ = card2copy.issuer_;
        this.issuerName_ = card2copy.issuerName_;
        this.timeLastUpdated_ = new Date();
        this.masterKey_ = card2copy.masterKey_;
    }

    public CardStorePersonalCard(ICardProvider provider, Element element) throws IOException, Exception {
        if (provider == null) {
            throw new IllegalArgumentException("Parameter \"provider\" is null");
        }
        if (element == null) {
            throw new IllegalArgumentException("Parameter \"element\" is null");
        }
        this.description_ = "CardStore CardSpace-interoperable personal I-Card";
        this.provider_ = provider;
        super.initFromXML(element);
    }

    public void setIId(URI id) {
        this.id_ = id;
    }

    public void setVersion(String version) {
        this.version_ = version;
    }

    public void setClaimList(List claims) throws CardException {
        super.setClaims(claims);
    }

    public void setPinCode(IPinCodeCredential pinCodeCredential) throws CardException {
    }

    public void applyUpdates() throws InvalidStateException, CardException {
    }

    public void beginUpdates() throws InvalidStateException {
    }

    public void cancelUpdates() throws InvalidStateException {
    }

    public boolean isEditMode() {
        return false;
    }

    public boolean isEditable() {
        return false;
    }

    public void setImage(byte[] newImage, String newImageType) throws CardException {
        this.image_ = newImage;
        this.imageMimeType_ = newImageType;
    }

    public void setIssuerName(String name) throws CardException {
        this.issuerName_ = name;
    }

    public void setName(String newName) throws CardException {
        this.name_ = newName;
    }

    public void setTimeIssued(Date date) throws CardException {
        this.timeIssued_ = date;
    }

    public void setTimeExpires(Date date) throws CardException {
        this.timeExpires_ = date;
    }

    public void setTimeLastUpdate(Date date) throws CardException {
        this.timeLastUpdated_ = date;
    }

    public IClaim createClaim(String type) throws InvalidTypeException, ReadOnlyObjectException {
        throw new ReadOnlyObjectException();
    }

    public IClaim setClaim(IClaim copyFrom) throws InvalidClaimException, InvalidTypeException, ReadOnlyObjectException {
        throw new ReadOnlyObjectException();
    }

    protected void retrieveClaims(ICredential credential) throws AuthenticationRequiredException, AuthenticationException, CardException {
        if (this.claimValues_ == null) {
            this.claimValues_ = new LinkedHashMap();
        }
        if (credential != null && credential instanceof IPinCodeCredential) {
            IPinCodeCredential ipc = (IPinCodeCredential)credential;
            byte[] pinCode = ipc.getPinCode();
            try {
                this.decrypt(pinCode);
            }
            catch (Exception e) {
                throw new CardException("Cannot decrypt the PIN protected card", (Throwable)e);
            }
        }
        Set claimTypeUris = this.dirtyClaimValueMap_.keySet();
        Object[] claimTypeStrs = claimTypeUris.toArray();
        int i = 0;
        while (claimTypeStrs != null && i < claimTypeStrs.length) {
            this.claimValues_.put(claimTypeStrs[i], this.dirtyClaimValueMap_.get(claimTypeStrs[i]));
            ++i;
        }
    }

    public void setPinCode(String pinCode) throws CardException {
    }

    public void setSupportedTokenTypeList(List supportedTokenTypes) {
        this.supportedTokenTypes_ = supportedTokenTypes;
    }

    public void setClaimsTypeList(List claimType) {
        this.claimTypes_ = claimType;
    }

    public void setMasterKey(byte[] key) {
        this.masterKey_ = key;
    }

    private void addTokenServiceList(Document doc, Element informationCardMetaData) {
        Element tokenServiceList = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "TokenServiceList");
        informationCardMetaData.appendChild(tokenServiceList);
        Element tokenService = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "TokenService");
        tokenServiceList.appendChild(tokenService);
        Element endpointReference = doc.createElementNS("http://www.w3.org/2005/08/addressing", "EndpointReference");
        tokenService.appendChild(endpointReference);
        Element address = doc.createElementNS("http://www.w3.org/2005/08/addressing", "Address");
        XMLUtils.setTextContent((Element)address, (String)ISSUER_SELF);
        endpointReference.appendChild(address);
        doc.createElementNS("http://www.w3.org/2005/08/addressing", "MetaData");
        XMLUtils.setTextContent((Element)address, (String)ISSUER_SELF);
        endpointReference.appendChild(address);
    }

    public boolean validatePINCode(String pinCode) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        byte[] userInputBytes = pinCode.getBytes("UTF-16LE");
        MessageDigest md = MessageDigest.getInstance("SHA1");
        md.update(userInputBytes);
        byte[] inputDigest = md.digest();
        return Arrays.equals(inputDigest, this.pinDigest_);
    }

    public void lock(IPinCodeCredential credential) throws Exception {
        if (this.pinStatus == 0) {
            byte[] pinCode = credential.getPinCode();
            this.encrypt(pinCode);
            String pinString = new String(pinCode, "UTF-8");
            byte[] unicodePinString = pinString.getBytes("UTF-16LE");
            MessageDigest md = MessageDigest.getInstance("SHA1");
            md.update(unicodePinString);
            this.pinDigest_ = md.digest();
            md.reset();
            this.pinStatus = 1;
        }
    }

    public void unlock(IPinCodeCredential credential) throws Exception {
        if (this.pinStatus == 1) {
            this.retrieveClaims((ICredential)credential);
            this.pinStatus = 2;
        }
    }

    private void encrypt(byte[] pinCode) throws NoSuchAlgorithmException, UnsupportedEncodingException, InvalidKeyException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, CardException {
        byte[] salt = new byte[16];
        SecureRandom.getInstance("SHA1PRNG").nextBytes(salt);
        byte[] byArray = new byte[4];
        byArray[0] = -24;
        byArray[1] = 3;
        byte[] iter_count = byArray;
        byte[] iv = new byte[16];
        SecureRandom.getInstance("SHA1PRNG").nextBytes(iv);
        MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
        sha256.update(pinCode);
        sha256.update(salt);
        byte[] key = sha256.digest();
        int i = 1;
        while (i < 1000) {
            sha256.update(key);
            key = sha256.digest();
            ++i;
        }
        sha256.reset();
        Set setClaimValues = this.dirtyClaimValueMap_.entrySet();
        Iterator values = setClaimValues.iterator();
        while (values.hasNext()) {
            Map.Entry meClaimValue = values.next();
            ClaimValue claim = (ClaimValue)meClaimValue.getValue();
            byte[] cleartext_bytes = claim.getValue().getBytes("UTF-16LE");
            byte[] encrypted_bytes = this.cipherField(1, iv, key, cleartext_bytes);
            String encrypted_str = Base64Utility.encode(encrypted_bytes);
            ArrayList<String> vl = new ArrayList<String>();
            vl.add(encrypted_str);
            claim.setValues(vl);
        }
        byte[] enc_master_key = this.cipherField(1, iv, key, this.masterKey_);
        this.masterKey_ = new byte[1 + enc_master_key.length + salt.length + iv.length + iter_count.length];
        this.masterKey_[0] = 2;
        System.arraycopy(salt, 0, this.masterKey_, 1, 16);
        System.arraycopy(iter_count, 0, this.masterKey_, 17, 4);
        System.arraycopy(iv, 0, this.masterKey_, 21, 16);
        System.arraycopy(enc_master_key, 0, this.masterKey_, 37, enc_master_key.length);
    }

    private void decrypt(byte[] pinCode) throws NoSuchAlgorithmException, CardException, InvalidKeyException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        byte[] master_key = this.getMasterKey();
        byte[] salt = new byte[16];
        System.arraycopy(master_key, 1, salt, 0, 16);
        byte[] iter_count = new byte[4];
        System.arraycopy(master_key, 17, iter_count, 0, 4);
        byte[] iv = new byte[16];
        System.arraycopy(master_key, 21, iv, 0, 16);
        MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
        sha256.update(pinCode);
        sha256.update(salt);
        byte[] key = sha256.digest();
        int i = 1;
        while (i < 1000) {
            sha256.update(key);
            key = sha256.digest();
            ++i;
        }
        sha256.reset();
        Set claimTypeUris = this.dirtyClaimValueMap_.keySet();
        Object[] claimTypeStrs = claimTypeUris.toArray();
        if (claimTypeStrs != null) {
            int i2 = 0;
            while (i2 < claimTypeStrs.length) {
                ClaimValue cv = (ClaimValue)this.dirtyClaimValueMap_.get(claimTypeStrs[i2]);
                byte[] value = Base64Utility.decode(cv.getValue());
                byte[] decrypted_value = this.cipherField(2, iv, key, value);
                String decrypted_str = new String(decrypted_value, "UTF-16LE");
                ArrayList<String> vl = new ArrayList<String>();
                vl.add(decrypted_str);
                cv.setValues(vl);
                ++i2;
            }
        }
        byte[] masterKeyValue = new byte[this.masterKey_.length - 37];
        System.arraycopy(this.masterKey_, 37, masterKeyValue, 0, this.masterKey_.length - 37);
        byte[] tmp = this.cipherField(2, iv, key, masterKeyValue);
        this.masterKey_ = (byte[])tmp.clone();
    }

    private byte[] cipherField(int mode, byte[] iv, byte[] derivedKey, byte[] field) throws CardException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        SecretKeySpec encKey = new SecretKeySpec(derivedKey, "AES");
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        IvParameterSpec ips = new IvParameterSpec(iv);
        cipher.init(mode, (Key)encKey, ips);
        byte[] out = cipher.doFinal(field);
        return out;
    }

    public IInformationCardExtension addExtension(IElement extension) throws CardException {
        throw new CardException("Not implemented");
    }

    public IInformationCardExtension[] getExtensions() {
        return null;
    }

    public boolean hasExtensions() {
        return false;
    }

    public void removeExtension(IInformationCardExtension extension) throws CardException {
        throw new CardException("Not implemented");
    }
}

