/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Patrick R Wardrop (IBM Corporation)
 *******************************************************************************/ 
package org.eclipse.higgins.cardstore.schemas._2005._05.identity.impl;

import org.eclipse.higgins.cardstore.Constants;
import org.eclipse.higgins.cardstore.LocalElementNames;
import org.eclipse.higgins.cardstore.exceptions.ExpectedObjectNotPresent;
import org.eclipse.higgins.cardstore.exceptions.UnsupportedObjectModel;
import org.eclipse.higgins.cardstore.resources.CardStoreMessages;
import org.eclipse.higgins.cardstore.schemas._2005._05.identity.ISelfIssuedCredential;
import org.eclipse.higgins.cardstore.utils.Base64Utility;
import org.eclipse.higgins.cardstore.utils.MessageHelper;
import org.eclipse.higgins.cardstore.utils.XmlUtils;
import org.w3c.dom.Element;

public class SelfIssedCredential implements ISelfIssuedCredential {
	public static String copyright = Constants.FULL_COPYRIGHT;
	
	private Element _selfIssedCredentialElement = null;
	
	private byte[] _ppid = null;	
	
	Object _parentNode = null;
	
	public Object getParent()
	{
		return _parentNode;
	}
	
	public void setParent(Object parentNode)
	{
		_parentNode = parentNode;
	}		
	
	public byte[] getPrivatePersonalIdentifier() {
		return _ppid;
	}

	public void setPrivatePersonalIdentifier(byte[] value) {
		_ppid = value;
	}

	public void fromXml(Object obj) throws UnsupportedObjectModel,
			ExpectedObjectNotPresent {
		_selfIssedCredentialElement = XmlUtils.retrieveElementFromObject(obj);
		
		if (!XmlUtils.isElementType(
				_selfIssedCredentialElement, 
				LocalElementNames.IDENTITY_SELF_ISSUED_CREDENTIAL, 
				Constants.NSURI_IDENTITY_2005_05) || _selfIssedCredentialElement == null)
		{
			_selfIssedCredentialElement = null;

			throw new ExpectedObjectNotPresent(
					MessageHelper.getMessage(
							CardStoreMessages.expected_object_not_present, 
							new Object[]{Constants.NSURI_IDENTITY_2005_05 + ":" + LocalElementNames.IDENTITY_SELF_ISSUED_CREDENTIAL}));
		}
		
		Element ppidElement = XmlUtils.retrieveFirstChildMatchOfType(
				_selfIssedCredentialElement, 
				LocalElementNames.IDENTITY_PRIVATE_PERSONAL_IDENTIFIER, 
				Constants.NSURI_IDENTITY_2005_05);
		
		if (ppidElement != null)
		{
			String s = XmlUtils.retrieveAllTextFromChildTextNodes(ppidElement);
			
			if (s != null && s.length() > 0)
			setPrivatePersonalIdentifier(Base64Utility.decode(s));
		}
	}

	public Object toXml() {
		// TODO Auto-generated method stub
		return null;
	}

}
