/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Patrick R Wardrop (IBM Corporation)
 *******************************************************************************/ 
package org.eclipse.higgins.cardstore.schemas._2005._05.identity.impl;

import org.eclipse.higgins.cardstore.Constants;
import org.eclipse.higgins.cardstore.LocalElementNames;
import org.eclipse.higgins.cardstore.exceptions.ExpectedObjectNotPresent;
import org.eclipse.higgins.cardstore.exceptions.UnsupportedObjectModel;
import org.eclipse.higgins.cardstore.resources.CardStoreMessages;
import org.eclipse.higgins.cardstore.schemas._2000._09.xmldsig.IX509Data;
import org.eclipse.higgins.cardstore.schemas._2000._09.xmldsig.impl.X509Data;
import org.eclipse.higgins.cardstore.schemas._2005._05.identity.IX509V3Credential;
import org.eclipse.higgins.cardstore.utils.MessageHelper;
import org.eclipse.higgins.cardstore.utils.XmlUtils;
import org.w3c.dom.Element;

public class X509V3Credential implements IX509V3Credential {
	public static String copyright = Constants.FULL_COPYRIGHT;
	
	private Element _x509v3CredentialElement = null;
	
	private IX509Data _x509Data = null;
	
	Object _parentNode = null;
	
	public Object getParent()
	{
		return _parentNode;
	}
	
	public void setParent(Object parentNode)
	{
		_parentNode = parentNode;
	}		
	
	public IX509Data getX509Data() {		
		return _x509Data;
	}

	public void setX509Data(IX509Data value) {
		_x509Data = value;
	}

	public void fromXml(Object obj) throws UnsupportedObjectModel,
			ExpectedObjectNotPresent {
		_x509v3CredentialElement = XmlUtils.retrieveElementFromObject(obj);
		
		if (!XmlUtils.isElementType(
				_x509v3CredentialElement, 
				LocalElementNames.IDENTITY_X509_V3_CREDENTIAL, 
				Constants.NSURI_IDENTITY_2005_05) || _x509v3CredentialElement == null)
		{
			_x509v3CredentialElement = null;
			throw new ExpectedObjectNotPresent(
					MessageHelper.getMessage(
							CardStoreMessages.expected_object_not_present, 
							new Object[]{Constants.NSURI_IDENTITY_2005_05 + ":" + LocalElementNames.IDENTITY_X509_V3_CREDENTIAL}));			
			
		}
		
		Element x509DataElement = XmlUtils.retrieveFirstChildMatchOfType(
				_x509v3CredentialElement, 
				LocalElementNames.DS_X509_DATA, 
				Constants.NSURI_DS_2000_09);

		if (x509DataElement != null)
		{
			_x509Data = new X509Data();
			_x509Data.fromXml(x509DataElement);
			((X509Data)_x509Data).setParent(this);
		}
	}

	public Object toXml() {
		// TODO Auto-generated method stub
		return null;
	}

}
