/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.registry;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.higgins.icard.CUID;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.ICard;
import org.eclipse.higgins.icard.ICardProvider;
import org.eclipse.higgins.icard.registry.utils.DataUtils;
import org.eclipse.higgins.icard.registry.utils.XMLUtils;
import org.eclipse.higgins.registry.HigginsRegistry;
import org.eclipse.higgins.registry.IIORegistryExtension;
import org.eclipse.higgins.registry.IRegistryExtension;
import org.eclipse.higgins.registry.SecurityRegistryExtension;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class ICardRegistry
extends HigginsRegistry {
    protected static ICardRegistry instance = null;
    static /* synthetic */ Class class$org$eclipse$higgins$icard$ICardProvider;

    protected ICardRegistry() {
        super(class$org$eclipse$higgins$icard$ICardProvider == null ? (class$org$eclipse$higgins$icard$ICardProvider = ICardRegistry.class$("org.eclipse.higgins.icard.ICardProvider")) : class$org$eclipse$higgins$icard$ICardProvider);
        this.initialize();
    }

    public ICardRegistry(String configPath) {
        super(class$org$eclipse$higgins$icard$ICardProvider == null ? (class$org$eclipse$higgins$icard$ICardProvider = ICardRegistry.class$("org.eclipse.higgins.icard.ICardProvider")) : class$org$eclipse$higgins$icard$ICardProvider, configPath);
        this.initialize();
    }

    private void initialize() {
        this.addExtension((IRegistryExtension)new IIORegistryExtension(class$org$eclipse$higgins$icard$ICardProvider == null ? (class$org$eclipse$higgins$icard$ICardProvider = ICardRegistry.class$("org.eclipse.higgins.icard.ICardProvider")) : class$org$eclipse$higgins$icard$ICardProvider));
        this.addExtension((IRegistryExtension)new SecurityRegistryExtension(class$org$eclipse$higgins$icard$ICardProvider == null ? (class$org$eclipse$higgins$icard$ICardProvider = ICardRegistry.class$("org.eclipse.higgins.icard.ICardProvider")) : class$org$eclipse$higgins$icard$ICardProvider));
        try {
            Class<?> c = Class.forName("org.eclipse.higgins.icard.registry.plugin.ICardRegistryExtension");
            IRegistryExtension e = (IRegistryExtension)c.newInstance();
            this.addExtension(e);
        }
        catch (ClassNotFoundException e) {
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        this.loadProviders();
    }

    public Iterator getICardProviders() {
        return this.getServiceProviders();
    }

    public ICardProvider getICardProvider(String extID) {
        if (extID == null) {
            throw new IllegalArgumentException("id == null!");
        }
        return (ICardProvider)this.getServiceProvider(extID);
    }

    public ICard getICardByCUID(CallbackHandler authHandler, String CUID2) throws CardException {
        return this.getICardByCUID(authHandler, new CUID(CUID2));
    }

    public ICard getICardByCUID(CallbackHandler authHandler, CUID cuid) throws CardException {
        ICardProvider p = this.getICardProvider(cuid.getProviderID());
        if (p == null) {
            throw new CardException("Can't find i-card provider with ID=\"" + cuid.getProviderID() + "\"");
        }
        return p.getICardByCUID(authHandler, cuid);
    }

    public void deleteICard(CallbackHandler authHandler, String CUID2) throws CardException {
        this.deleteICard(authHandler, new CUID(CUID2));
    }

    public void deleteICard(CallbackHandler authHandler, CUID cuid) throws CardException {
        ICardProvider p = this.getICardProvider(cuid.getProviderID());
        if (p == null) {
            throw new CardException("Can't find i-card provider with ID=\"" + cuid.getProviderID() + "\"");
        }
        ICard c = p.getICardByCUID(authHandler, cuid);
        if (c == null) {
            throw new CardException("Can't find i-card with CUID=\"" + cuid + "\"");
        }
        p.deleteCard(authHandler, c);
    }

    public void importICards(CallbackHandler authHandler, InputStream in) throws CardException {
        block19: {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ByteArrayInputStream tmp = null;
            try {
                DataUtils.copy(in, out);
                tmp = new ByteArrayInputStream(out.toByteArray());
                DocumentBuilderFactory f = DocumentBuilderFactory.newInstance();
                f.setNamespaceAware(true);
                DocumentBuilder builder = f.newDocumentBuilder();
                Document doc = builder.parse(tmp);
                Element root = doc.getDocumentElement();
                String name = root.getNodeName();
                CardException lastErr = null;
                if (name.equals("EncryptedStore")) {
                    break block19;
                }
                Iterator itr = this.getICardProviders();
                while (itr.hasNext()) {
                    ICardProvider p = (ICardProvider)itr.next();
                    if (!p.canImportICard(authHandler, root)) continue;
                    try {
                        ICard c = p.importICard(authHandler, root);
                        if (c == null) continue;
                        return;
                    }
                    catch (CardException e) {
                        lastErr = e;
                    }
                }
                if (lastErr != null) {
                    throw lastErr;
                }
                throw new CardException("Can't find suitable provider to import i-card \n[\n" + XMLUtils.toString(root) + "\n]");
            }
            catch (ParserConfigurationException e) {
                throw new CardException("Can't initialize xml parser", (Throwable)e);
            }
            catch (SAXException e) {
                throw new CardException("Input is not valid xml", (Throwable)e);
            }
            catch (IOException e) {
                throw new CardException("Can't read import data", (Throwable)e);
            }
            finally {
                try {
                    in.close();
                }
                catch (Exception e) {}
            }
        }
    }

    protected String getConfigFolder() {
        return ".icard";
    }

    public static synchronized ICardRegistry getInstance() {
        if (instance == null) {
            instance = new ICardRegistry();
        }
        return instance;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

