/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.registry;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.security.auth.callback.CallbackHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.CUID;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.ICard;
import org.eclipse.higgins.icard.ICardProvider;
import org.eclipse.higgins.icard.auth.ICredential;
import org.eclipse.higgins.icard.io.IElement;
import org.eclipse.higgins.icard.io.IElementFormat;
import org.eclipse.higgins.icard.io.IFormatDescriptor;
import org.eclipse.higgins.icard.io.IFormatProvider;
import org.eclipse.higgins.icard.io.IICardElement;
import org.eclipse.higgins.icard.io.IInputProcessor;
import org.eclipse.higgins.icard.io.IOutputProcessor;
import org.eclipse.higgins.icard.registry.IOFormatRegistry;
import org.eclipse.higgins.icard.registry.UserProfileRegistry;
import org.eclipse.higgins.icard.registry.utils.DataUtils;
import org.eclipse.higgins.icard.userprofile.IUserProfileService;
import org.eclipse.higgins.registry.HigginsRegistry;
import org.eclipse.higgins.registry.IIORegistryExtension;
import org.eclipse.higgins.registry.IRegistryExtension;
import org.eclipse.higgins.registry.SecurityRegistryExtension;

public class ICardRegistry
extends HigginsRegistry {
    private Log log;
    protected static ICardRegistry instance = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected ICardRegistry() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.higgins.icard.ICardProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super((Class)clazz);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.higgins.icard.registry.ICardRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.log = LogFactory.getLog((Class)clazz2);
        this.initialize();
    }

    public ICardRegistry(String configPath) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.higgins.icard.ICardProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super((Class)clazz, configPath);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.higgins.icard.registry.ICardRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.log = LogFactory.getLog((Class)clazz2);
        this.initialize();
    }

    private void initialize() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.higgins.icard.ICardProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addExtension((IRegistryExtension)new IIORegistryExtension((Class)clazz));
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.higgins.icard.ICardProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addExtension((IRegistryExtension)new SecurityRegistryExtension((Class)clazz2));
        try {
            Class<?> c = Class.forName("org.eclipse.higgins.icard.registry.plugin.ICardRegistryExtension");
            IRegistryExtension e = (IRegistryExtension)c.newInstance();
            this.addExtension(e);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        this.loadProviders();
    }

    public Iterator getICardProviders() {
        return this.getServiceProviders();
    }

    public ICardProvider getICardProvider(String extID) {
        if (extID == null) {
            throw new IllegalArgumentException("id == null!");
        }
        return (ICardProvider)this.getServiceProvider(extID);
    }

    public ICard getICardByCUID(CallbackHandler authHandler, String CUID2) throws CardException {
        return this.getICardByCUID(authHandler, new CUID(CUID2));
    }

    public ICard getICardByCUID(CallbackHandler authHandler, CUID cuid) throws CardException {
        ICardProvider p = this.getICardProvider(cuid.getProviderID());
        if (p == null) {
            throw new CardException("Can't find i-card provider with ID=\"" + cuid.getProviderID() + "\"");
        }
        return p.getICardByCUID(authHandler, cuid);
    }

    public void deleteICard(CallbackHandler authHandler, String CUID2) throws CardException {
        this.deleteICard(authHandler, new CUID(CUID2));
    }

    public void deleteICard(CallbackHandler authHandler, CUID cuid) throws CardException {
        ICardProvider p = this.getICardProvider(cuid.getProviderID());
        if (p == null) {
            throw new CardException("Can't find i-card provider with ID=\"" + cuid.getProviderID() + "\"");
        }
        ICard c = p.getICardByCUID(authHandler, cuid);
        if (c == null) {
            throw new CardException("Can't find i-card with CUID=\"" + cuid + "\"");
        }
        p.deleteCard(authHandler, c);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IFormatDescriptor checkInput(InputStream in) {
        IFormatDescriptor fd;
        IFormatDescriptor format = null;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayInputStream copy = null;
        try {
            try {
                DataUtils.copy(in, out);
            }
            catch (IOException e) {
                this.log.trace((Object)e);
                IFormatDescriptor iFormatDescriptor = format;
                Object var6_9 = null;
                try {
                    in.close();
                    return iFormatDescriptor;
                }
                catch (Exception exception) {}
                return iFormatDescriptor;
            }
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            try {}
            catch (Exception exception) {}
            in.close();
            throw throwable;
            throw throwable;
        }
        {
            Object var6_11 = null;
        }
        try {}
        catch (Exception exception) {}
        in.close();
        copy = new ByteArrayInputStream(out.toByteArray());
        IOFormatRegistry formatRegistry = IOFormatRegistry.getInstance();
        Iterator itr = formatRegistry.getFormatProviders();
        while (true) {
            if (!itr.hasNext()) {
                return format;
            }
            IFormatProvider p = (IFormatProvider)itr.next();
            IInputProcessor ip = p.getInputProcessor();
            if (ip == null) continue;
            copy.reset();
            fd = ip.checkInput((InputStream)copy);
            if (fd != null) break;
        }
        return fd;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Iterator importICards(CallbackHandler authHandler, InputStream in, String formatID, ICredential credential) throws CardException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayInputStream copy = null;
        try {
            try {
                DataUtils.copy(in, out);
            }
            catch (IOException e) {
                this.log.trace((Object)e);
                throw new CardException("Can't read import data", (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            try {
                in.close();
                throw throwable;
            }
            catch (Exception exception) {}
            throw throwable;
        }
        {
            Object var8_12 = null;
        }
        try {}
        catch (Exception exception) {}
        in.close();
        copy = new ByteArrayInputStream(out.toByteArray());
        IElement[] elements = null;
        IOFormatRegistry formatRegistry = IOFormatRegistry.getInstance();
        IFormatProvider fp = null;
        IInputProcessor ip = null;
        if (formatID != null && (fp = formatRegistry.getFormatProvider(formatID)) != null) {
            ip = fp.getInputProcessor();
        }
        if (ip == null) {
            Iterator itr = formatRegistry.getFormatProviders();
            while (itr.hasNext()) {
                fp = (IFormatProvider)itr.next();
                IInputProcessor ipp = fp.getInputProcessor();
                if (ipp == null) continue;
                copy.reset();
                if (ipp.checkInput((InputStream)copy) == null) continue;
                ip = ipp;
                break;
            }
        }
        if (ip != null) {
            copy.reset();
            elements = ip.process((InputStream)copy, credential);
        }
        if (elements == null) {
            throw new CardException("Can't find suitable format provider to process import data");
        }
        ArrayList<ICard> cards = new ArrayList<ICard>();
        int i = 0;
        while (i < elements.length) {
            CUID cuid;
            ICardProvider p = null;
            IICardElement iio = null;
            CardException lastErr = null;
            String pID = null;
            if (elements[i] instanceof IICardElement && (cuid = (iio = (IICardElement)elements[i]).getCUID()) != null) {
                pID = cuid.getProviderID();
            }
            if (pID != null) {
                p = this.getICardProvider(pID);
            }
            ICard card = null;
            if (p != null && p.canImportICard(authHandler, elements[i])) {
                try {
                    card = p.importICard(authHandler, elements[i]);
                }
                catch (CardException e) {
                    this.log.debug((Object)"Can't import card", (Throwable)e);
                    card = null;
                    lastErr = e;
                }
            }
            if (card == null) {
                Iterator itr = this.getICardProviders();
                while (itr.hasNext()) {
                    p = (ICardProvider)itr.next();
                    if (p.canImportICard(authHandler, elements[i])) {
                        try {
                            card = p.importICard(authHandler, elements[i]);
                        }
                        catch (CardException e) {
                            card = null;
                            this.log.debug((Object)"Can't import card", (Throwable)e);
                            lastErr = e;
                        }
                    }
                    if (card == null) continue;
                }
            }
            if (card == null) {
                if (lastErr == null) {
                    this.log.trace((Object)("Can't find suitable provider to import card: " + elements[i].toString()));
                } else {
                    this.log.trace((Object)("Can't import card: " + elements[i].toString()), (Throwable)lastErr);
                }
            } else {
                cards.add(card);
            }
            ++i;
        }
        return cards.iterator();
    }

    public IFormatProvider getFormatProvider(String formatID) {
        return IOFormatRegistry.getInstance().getFormatProvider(formatID);
    }

    public IFormatDescriptor[] getOutputFormats() {
        IFormatDescriptor[] res = null;
        IOFormatRegistry formatRegistry = IOFormatRegistry.getInstance();
        ArrayList<IFormatDescriptor> formats = new ArrayList<IFormatDescriptor>();
        Iterator itr = formatRegistry.getFormatProviders();
        while (itr.hasNext()) {
            IFormatDescriptor fd;
            IFormatProvider p = (IFormatProvider)itr.next();
            IOutputProcessor ip = p.getOutputProcessor();
            if (ip == null || (fd = p.getFormatDescriptor()) == null) continue;
            formats.add(fd);
        }
        res = formats.toArray(new IFormatDescriptor[formats.size()]);
        return res;
    }

    public Iterator getICardsByFormat(CallbackHandler authHandler, String formatID) throws CardException {
        ArrayList res = new ArrayList();
        IFormatProvider fp = this.getFormatProvider(formatID);
        if (fp == null) {
            throw new CardException("Can't find format provider with id=\"" + formatID + "\"");
        }
        IOutputProcessor op = fp.getOutputProcessor();
        if (op == null) {
            throw new CardException("Format provider with id=\"" + formatID + "\" doesn't support output operations.");
        }
        IFormatDescriptor fd = fp.getFormatDescriptor();
        if (fd == null) {
            throw new CardException("Format provider with id=\"" + formatID + "\" doesn't have valid format descriptor.");
        }
        IElementFormat ed = fd.getElementDescriptor();
        if (ed == null) {
            throw new CardException("Format provider with id=\"" + formatID + "\" doesn't have valid element descriptor.");
        }
        Iterator itr = this.getICardProviders();
        while (itr.hasNext()) {
            ICardProvider cp = (ICardProvider)itr.next();
            Iterator itrc = cp.getICardsByFormat(authHandler, ed);
            while (itrc.hasNext()) {
                res.add(itrc.next());
            }
        }
        return res.iterator();
    }

    public void exportICards(CallbackHandler authHandler, OutputStream out, String formatID, CUID[] cards, ICredential credential) throws CardException {
        IFormatProvider fp = this.getFormatProvider(formatID);
        if (fp == null) {
            throw new CardException("Can't find format provider with id=\"" + formatID + "\"");
        }
        IOutputProcessor op = fp.getOutputProcessor();
        if (op == null) {
            throw new CardException("Format provider with id=\"" + formatID + "\" doesn't support output operations.");
        }
        IFormatDescriptor fd = fp.getFormatDescriptor();
        if (fd == null) {
            throw new CardException("Format provider with id=\"" + formatID + "\" doesn't have valid format descriptor.");
        }
        IElementFormat ed = fd.getElementDescriptor();
        if (ed == null) {
            throw new CardException("Format provider with id=\"" + formatID + "\" doesn't have valid element descriptor.");
        }
        HashMap<String, ArrayList<CUID>> map = new HashMap<String, ArrayList<CUID>>();
        int i = 0;
        while (i < cards.length) {
            String pid = cards[i].getProviderID();
            if (pid == null) {
                this.log.error((Object)("Can't find provider for card with CUID=\"" + cards[i] + "\""));
            } else {
                ArrayList<CUID> l = (ArrayList<CUID>)map.get(pid);
                if (l == null) {
                    l = new ArrayList<CUID>();
                    map.put(pid, l);
                }
                l.add(cards[i]);
            }
            ++i;
        }
        ArrayList<IElement> elements = new ArrayList<IElement>();
        Iterator itr = map.keySet().iterator();
        while (itr.hasNext()) {
            String pid = (String)itr.next();
            ICardProvider cp = this.getICardProvider(pid);
            if (cp == null) {
                throw new CardException("Can't find provider with id=\"" + pid + "\"");
            }
            List l = (List)map.get(pid);
            elements.addAll(Arrays.asList(cp.exportICards(authHandler, ed, l.toArray(new CUID[l.size()]))));
        }
        op.process(elements.toArray(new IElement[elements.size()]), out, credential);
    }

    protected String getConfigFolder() {
        return ".icard";
    }

    public static synchronized ICardRegistry getInstance() {
        if (instance == null) {
            instance = new ICardRegistry();
        }
        return instance;
    }

    public IUserProfileService getUserProfileService() {
        Iterator it = UserProfileRegistry.getInstance().getServiceProviders();
        if (it.hasNext()) {
            return (IUserProfileService)it.next();
        }
        return null;
    }
}

