/** 
 * Copyright (c) 2007-2008 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 *		Yuriy Pilipenko - API and implementation 
 * 
 */
package org.eclipse.higgins.icard.registry;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.common.userprofile.MemoryUserProfileService;
import org.eclipse.higgins.icard.userprofile.IUserProfileService;
import org.eclipse.higgins.icard.userprofile.UserProfileException;
import org.eclipse.higgins.registry.HigginsRegistry;
import org.eclipse.higgins.registry.IIORegistryExtension;
import org.eclipse.higgins.registry.IRegistryExtension;
import org.eclipse.higgins.registry.SecurityRegistryExtension;

/**
 * @author PilipenkoYN
 *
 */
public class UserProfileRegistry extends HigginsRegistry {
	private Log log = LogFactory.getLog(ICardRegistry.class);	
	private static UserProfileRegistry instance = null;

	/**
	 * Set up the valid service provider categories and automatically register
	 * all available service providers.
	 * 
	 * <p>
	 * The constructor is protected in order to prevent creation of additional
	 * instances.
	 */
	protected UserProfileRegistry() {
		super(IUserProfileService.class);
		initialize();
	}

	/**
	 * @param configPath
	 */
	public UserProfileRegistry(String configPath) {
		super(IUserProfileService.class, configPath);
		initialize();
	}
	
	private void initialize() {
		addExtension(new IIORegistryExtension(IUserProfileService.class));
		addExtension(new SecurityRegistryExtension(IUserProfileService.class));
		try {
			Class c = Class.forName("org.eclipse.higgins.icard.registry.plugin.UserProfileRegistryExtension");
			IRegistryExtension e = (IRegistryExtension) c.newInstance();
			addExtension(e);
		} catch (ClassNotFoundException e) {
		} catch (Throwable e) {
			log.error(e);
		}
		loadProviders();
	
		try {
			if (providers.size() > 1 ) {
				log.warn("There are more than one User Profile Service providers! " + providers.keySet().toString());
			}
			//if no user profile service provider found, adding default implementation
			if (providers.size() == 0) {
				add(new MemoryUserProfileService());
			}
		} catch (Exception e) {
			log.error(e);
		}
			
	}

	protected String getConfigFolder() {
		return ".icard"; //+ File.pathSeparator+ ".userprofile";
	}

	public synchronized static UserProfileRegistry getInstance() {
		if (instance == null) {
			instance = new UserProfileRegistry();
		}
		return instance;
	}	

}
