/*******************************************************************************
 * Copyright (c) 2007 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - Initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.icard.registry.utils;

import java.io.ByteArrayOutputStream;

import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.w3c.dom.Element;

public class XMLUtils {
	public static String stripNamespaceDeclaration(String strElement) {
		boolean bNamespaceDeclaration = strElement.startsWith("<?xml");
		if (!bNamespaceDeclaration) {
			return strElement;
		}
		final String strResult = strElement.substring(1);
		final int nBegin = strResult.indexOf("<");
		return strResult.substring(nBegin);
	}
	
	public static String toString(Element domElement) {
		if (null == domElement) {
			return null;
		}
		String strElement = "";
		ByteArrayOutputStream outputStream;
		try {
			DOMSource s = new DOMSource(domElement);
			TransformerFactory f = TransformerFactory.newInstance(); 
			Transformer t = f.newTransformer();
			outputStream = new ByteArrayOutputStream();
			Result r = new StreamResult(outputStream);
			t.transform(s, r);
			strElement = outputStream.toString("UTF-8");
		} catch (Exception e) {
			e.printStackTrace();
		}

		strElement = stripNamespaceDeclaration(strElement);

		return strElement;
	}
}
