/*******************************************************************************
 * Copyright (c) 2006-2007 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - Initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.icard.registry.plugin;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.higgins.icard.ICardProvider;
import org.eclipse.higgins.registry.IServiceProvider;
import org.eclipse.higgins.registry.RegistryException;
import org.eclipse.higgins.registry.plugin.PluginRegistryExtension;

public class ICardRegistryExtension extends PluginRegistryExtension {

	private static final String XPID = "org.eclipse.higgins.icard.provider";

	public ICardRegistryExtension() {
		super(XPID);
	}

	public IServiceProvider createProvider(IExtension extension, IConfigurationElement element) throws RegistryException {
		try {
			Object o = element.createExecutableExtension("class");
			if (o instanceof ICardProvider) {
				ICardProvider provider = (ICardProvider) o;
				String id = element.getAttribute("id");
				if (provider.getID() == null && id != null) {
					provider.setID(id);
				}
				return provider;
			} else {
				throw new RegistryException("Invalid provider!");
			}
		} catch (Exception e) {
			throw new RegistryException(e);
		}
	}
}
