/**
 * Copyright (c) 2007 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergey Lyakhov - initial API and implementation
 */

package org.eclipse.higgins.icard;

/**
 * Declares which data should the user provide to create a card
 */
public interface ICardTemplate extends ITemplateContainer {

	/**
	 * @return ID of provider prodused this template
	 */
	public String getProviderID();

	/**
	 * @param providerID
	 *            ID of provider prodused this template
	 */
	public void setProviderID(String providerID);

	/**
	 * @return Name of provider prodused this template
	 */
	public String getProviderName();

	/**
	 * @param providerName
	 */
	public void setProviderName(String providerName);

	/**
	 * @return Description of provider prodused this template
	 */
	public String getProviderDescription();

	/**
	 * @param providerDescription
	 */
	public void setProviderDescription(String providerDescription);

	public Class getCardType();
}
