/*******************************************************************************
 * Copyright (c) 2006-2007 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - Initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.icard;

/**
 * The <code>IClaimType</code> interface defines a set of methods to describe
 * the type of an {@link IClaim} objects and provides an information on how to
 * display/edit it as well as an information about its structure and data types.
 */
public interface IClaimType {
	/**
	 * Return a string representation of URI which represents the type
	 * (identifier) of the corresponding claim.
	 */
	public String getType();
	
	public String getTypeLocalName();

	/**
	 * Return the human friendly name of the corresponding claim.
	 */
	public String getDisplayName();

	/**
	 * Return extended description of the corresponding claim.
	 */
	public String getDescription();

	/**
	 * Determines whether correcponding {@link IClaim} is simple or complex.
	 */
	public boolean isSimple();
}
