/*******************************************************************************
 * Copyright (c) 2007 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - Initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.icard;

import java.util.StringTokenizer;

public class CUID {
	protected String providerID;
	protected String issuer;
	protected String cardID;

	public CUID(final String providerID, final String issuer, final String cardID) {
		this.providerID = providerID;
		this.issuer = issuer;
		this.cardID = cardID;
	}
	
	public CUID(String str) throws CardException {
		StringTokenizer t = new StringTokenizer(str, "#");
		if (t.countTokens() != 3) {
			throw new CardException("Invalid string representationformat of CUID: str=\"" + str + "\"");
		}
		providerID = t.nextToken();
		issuer = t.nextToken();
		cardID = t.nextToken();
	}

	/**
	 * @return the cardID
	 */
	public String getCardID() {
		return cardID;
	}

	/**
	 * @return the issuer
	 */
	public String getIssuer() {
		return issuer;
	}

	/**
	 * @return the providerID
	 */
	public String getProviderID() {
		return providerID;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	public boolean equals(Object obj) {
		if (obj instanceof CUID) {
			CUID c = (CUID) obj;
			return providerID.equals(c.providerID) && issuer.equals(c.issuer) && cardID.equals(c.cardID); 
		} else if (obj instanceof String) {
			CUID c = null;
			try {
				c = new CUID((String) obj);
			} catch (Exception e) {
				e.printStackTrace();
				return false;
			}
			return equals(c);
		}
		return false;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		return providerID + "#" + issuer + "#" + cardID;
	}
}
