/**
 * Copyright (c) 2007 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergey Lyakhov - initial API and implementation
 */

package org.eclipse.higgins.icard;

import java.util.List;

import org.w3c.dom.Element;

/**
 * Represents managed CardSpace-interoperable I-Card
 */
public interface IManagedInformationCard extends IInformationCard {

	/**
	 * An ordered list of security token services
	 */
	public List getTokenServices();

	/**
	 * Indicates that RST must include information identifying the relying
	 * party.
	 */
	public Boolean getRequireAppliesTo();

	/**
	 * PrivacyNotice XML element as it was imported from xml file
	 */
	public Element getPrivacyNotice();

}
