/**
 * Copyright (c) 2007 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergey Lyakhov - initial API and implementation
 */

package org.eclipse.higgins.icard;

import java.net.URI;

/**
 * Represents personal CardSpace-interoperable I-Card
 */
public interface IPersonalInformationCard extends IInformationCard {

	/**
	 * Contains the base64 encoded bytes of the SHA1 hash of the pin code
	 * 
	 * @throws CardException
	 */
	public byte[] getPinDigest() throws CardException;

	/**
	 * Used to set/remove pin protection
	 * 
	 * @param pinCode
	 * @throws CardException
	 */
	public void setPinCode(String pinCode) throws CardException;

	/**
	 * URI of the context where DigitalSubject with claim values of the card is
	 * stored
	 */
	public URI getClaimListContextID();

	/**
	 * ID of DigitalSubject which holds claim values of the card
	 */
	public String getClaimListSubjectID();

}
