/*******************************************************************************
 * Copyright (c) 2006-2007 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Paul Trevithick - Initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.icard;


import org.eclipse.higgins.icard.ICard;

public interface IPolicy {
	/**
	 * Represents the type of this policy (e.g. "uri", "cardspace", "idemix",
	 * "openid", etc.)
	 */
	public String getType();

	/**
	 * Returns an array of <code>ICard</code> interfaces that could
	 * satisfy this policy.
	 */
	public Class[] getICardTypes();
	
	/**
	 * Gets short description of each claim in this policy;
	 */
	public String[] getSummary();

	/**
	 * Checks whether this policy could be satisfied with given
	 * <code>icard</code>.
	 */
	public boolean isSatisfiedBy(ICard icard);
}
