/** 
 * Copyright (c) 2007 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 *		Yuriy Pilipenko - API and implementation 
 * 
 */
package org.eclipse.higgins.icard.userprofile;

import java.net.URI;
import java.util.Date;

import org.eclipse.higgins.icard.CUID;

/**
 * @author PilipenkoYN
 *
 */
public class CardUsage {
	private CUID cuid;
	private URI site;
	private Date date;
	private Boolean useAlways;
	
	public static final String BY_SITE = "site";
	public static final String BY_DATE = "date";
	public static final String BY_USE = "useAlways";

	public CardUsage()
	{		
	}

	public CardUsage(CUID cuid, URI site, Date date, Boolean useAlways) {
		super();
		this.cuid = cuid;
		this.site = site;
		this.date = date;
		this.useAlways = useAlways;
	}

	public CUID getCuid() {
		return cuid;
	}
	public void setCuid(CUID cuid) {
		this.cuid = cuid;
	}	

	public URI getSite() {
		return site;
	}
	public void setSite(URI site) {
		this.site = site;
	}

	public Date getDate() {
		return date;
	}
	public void setDate(Date date) {
		this.date = date;
	}
	
	public Boolean getUseAlways() {
		return useAlways;
	}
	public void setUseAlways(Boolean useAlways) {
		this.useAlways = useAlways;
	}

	public boolean equals(Object obj) {
		if (obj instanceof CardUsage) {
			CardUsage cu = (CardUsage) obj;
			return cuid.equals(cu.cuid) && site.equals(cu.site);
		}
		return false;
	}

	public int hashCode() {
		return cuid.hashCode() ^ site.hashCode();
	}
	
}
