/** 
 * Copyright (c) 2007 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 *		Yuriy Pilipenko - API and implementation 
 * 
 */
package org.eclipse.higgins.icard.userprofile;

import java.util.List;
import javax.security.auth.callback.CallbackHandler;
import org.eclipse.higgins.icard.CUID;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.registry.IServiceProvider;


/**
 * @author Yuriy Pilipenko
 *
 */
public interface IUserProfileService extends IServiceProvider {

	/**
	 * @param userIdentifier
	 * @param password
	 * @return  
	 * @throws CardException 
	 */
	public UserProfile getUserProfile(CallbackHandler handler) throws UserProfileException;

	/**
	 * @param userProfile
	 * @return  
	 * @throws CardException 
	 */
	public UserProfile addUserProfile(CallbackHandler handler, UserProfile userProfile) throws UserProfileException;

	/**
	 * @param userProfile
	 * @return  
	 */
	public UserProfile modifyUserProfile(CallbackHandler handler, UserProfile userProfile) throws UserProfileException;

	/**
	 * @param userIdentifier
	 * @param password
	 * @return  
	 */
	public void deleteUserProfile(CallbackHandler handler) throws UserProfileException;

	/**
	 * @param userIdentifier
	 * @return
	 */
	public String resetPassword(CallbackHandler handler) throws UserProfileException;

	/**
	 * @param userIdentifier
	 * @return true if the specified user profile already exists
	 */
	public boolean userIdentifierExists(String userIdentifier) throws UserProfileException;
	
	/**
	 * @param handler - authentication handler
	 * @return List object with all user categories.  
	 */
	public List getCategories(CallbackHandler handler) throws UserProfileException;
	
	/**
	 * @param handler - authentication handler
	 * @param category
	 * @return new created category instance.
	 */
	public Category addCategory(CallbackHandler handler, Category category) throws UserProfileException;

	/**
	 * @param handler - authentication handler
	 * @param category
	 * @return updated category instance .
	 */
	public Category modifyCategory(CallbackHandler handler, Category category) throws UserProfileException;

	/**
	 * @param categoryId
	 * @param userIdentifier
	 * @param password
	 * @return .
	 */
	public void deleteCategory(CallbackHandler handler, String categoryId) throws UserProfileException;
	
	/**
	 * Sets credential information for the given card.
	 * @param handler
	 * @param cuid
	 * @param cardCredential
	 * @return CardInformation object with all related card information, or null if card info not found
	 */
	public CardInformation setCardCredential(CallbackHandler handler, CUID cuid, CardCredential cardCredential) throws UserProfileException;
	
	/**
	 * Clears credential information for the given card.
	 * @param handler
	 * @param cardCredentialInfo  
	 * @return CardInformation object with all related card information, or null if card info not found 
	 * @throws UserProfileException
	 */ 
	public CardInformation clearCardCredential(CallbackHandler handler, CUID cuid) throws UserProfileException;
	
/*	*//**
	 * Returns information about card remebered for this site.
	 * @param handler
	 * @param URI
	 * @return CardInformation object with all related card information, or null if card info not found
	 * @throws UserProfileException
	 *//*
	public CardInformation getCardInformation(CallbackHandler handler, URI URI) throws UserProfileException;
*/	
	/**
	 * Returns the whole information about the given card 
	 * @param handler
	 * @param cuid
	 * @return
	 */
	public CardInformation getCardInformation(CallbackHandler handler, CUID cuid) throws UserProfileException;
	
	/**
	 * Returns class that manages all Card usage and URI relations information
	 * @param handler
	 * @return instance of ICardUsageRelationManager
	 * @throws UserProfileException
	 */
	public ICardUsageManager getCardUsageManager(CallbackHandler handler) throws UserProfileException;
	
}