/*******************************************************************************
 * Copyright (c) 2006-2007 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - Initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.icard.policy;

import java.util.List;

import org.eclipse.higgins.icard.IClaimType;

public interface ICardSpacePolicy extends IRPPolicy {
	
	/**
	 * Specifies the URL of the STS from which to obtain a token. If omitted, no
	 * specific STS is requested. The special value
	 * "urn:schemas-microsoft-com:ws:2005:05:identity:issuer:self" specifies
	 * that the token should come from a self-issued identity provider.
	 */
	public String getIssuer();

	/**
	 * Specifies the URL of an endpoint from which the STS's policy can be
	 * retrieved. If omitted, the value "<issuer>/mex" is used.
	 */
	public String getIssuerPolicy();

	/**
	 * Specifies the type of the token to be requested from the STS as
	 * <code>String</code> which represents token type URI. This parameter can
	 * be omitted if the STS and the Web site front-end have a mutual
	 * understanding about what token type will be provided, or if the Web site
	 * is willing to accept any token type.
	 */
	//public Iterator getTokenTypes();

	/**
	 * Specifies the type of the token to be requested from the STS as
	 * <code>String</code> which represents token type URI. This parameter can
	 * be omitted if the STS and the Web site front-end have a mutual
	 * understanding about what token type will be provided, or if the Web site
	 * is willing to accept any token type.
	 */
	public String getTokenType();

	/**
	 * This parameter specifies the types of claims that must be supplied by the
	 * identity. All claim's types are returned as <code>String</code>.
	 * 
	 * @see IClaimType
	 */
	public List getRequiredClaims();
	
	/**
	 * Specifies the types of optional claims that may be supplied by the
	 * identity. All claim's types are returned as <code>String</code>.
	 * 
	 * @see IClaimType
	 */
	public List getOptionalClaims();
	
	/**
	 * Gets short description of optional claim in this policy;
	 * 
	 */
	public String[] getOptionalClaimSummary();
}
