/*******************************************************************************
 * Copyright (c) 2006-2007 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - Initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.icard.policy;

import java.net.URI;
import java.net.URL;


public interface IRSSPPolicy extends IRPPolicy {
	/**
	 * Returns the URI of OWL-DL schema of the card which describes types of
	 * claims requested. This schema must be based on the Higgins Ontology.
	 * <p>
	 * This URI should be used to create new card when required card doesn't
	 * exists.
	 */
	public URI getSchema();

	/**
	 * Returns the URI of background image of the card.
	 * <p>
	 * This URI should be used to create new card when required card doesn't
	 * exists.
	 */
	public URI getImage();

	/**
	 * Returns the URL of site's notification script which should be used for
	 * RSS-P notifications. No RSS-P notifications should be performed if
	 * <code>null</code> is returned.
	 * <p>
	 * This URL should be used to create new card when required card doesn't
	 * exists.
	 */
	public URL getNotificationURL();

}
