/*******************************************************************************
 * Copyright (c) 2006-2007 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Paul Trevithick - Initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.icard;

import java.net.URI;
import java.security.cert.X509Certificate;

import org.w3c.dom.Element;

public interface IEndpointReference {

	/**
	 * @return
	 */
	public URI getAddress();

	/**
	 * @return Metadata Address URI if Metadata contains it
	 */
	public URI getMetadataAddress();

	/**
	 * @return Metadata element of TokenService
	 */
	public Element getMetadata();

	/**
	 * @return Identity element of TokenService
	 */
	public Element getIdentity();

	/**
	 * @return X509Certificate if Identity contains it
	 */
	public X509Certificate getCertificate();

}
