/** 
 * Copyright (c) 2007 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 *		Yuriy Pilipenko - API and implementation 
 * 
 */
package org.eclipse.higgins.icard.userprofile;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.List;
import java.util.Set;

/**
 * @author PilipenkoYN
 * 
 */
public class UserProfile implements Serializable {

	private String loginName;

	private String password;

	private String firstName;

	private String lastName;

	private String email;

	private String status;

	private Date created;

	private Date modified;

	private String usedFrom;

	private String userIdentifier;

	private ByteBuffer passwordHash;
	
	private String privateUserINumber;
	
	private List privateSelectorINumbers;
	
	private String oneTimePassword;
	
	private Set blackListedSites;
	
	/**
	 * @return the email
	 */
	public String getEmail() {
		return this.email;
	}

	/**
	 * @param email
	 *            the email to set
	 */
	public void setEmail(String email) {
		this.email = email;
	}

	/**
	 * @return the firstName
	 */
	public String getFirstName() {
		return this.firstName;
	}

	/**
	 * @param firstName
	 *            the firstName to set
	 */
	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}

	/**
	 * @return the lastName
	 */
	public String getLastName() {
		return this.lastName;
	}

	/**
	 * @param lastName
	 *            the lastName to set
	 */
	public void setLastName(String lastName) {
		this.lastName = lastName;
	}

	/**
	 * @return the password (this password not for authentication!)
	 */
	public String getPassword() {
		return this.password;
		// return password == null? null : (char[])password.clone());
	}

	/**
	 * @param password
	 *            the password to set (this password not for authentication!)
	 */
	public void setPassword(String password) {
		// this.password = password;
		this.password = password;
	}

	/**
	 * @return the status
	 */
	public String getStatus() {
		return this.status;
	}

	/**
	 * @param status
	 *            the status to set
	 */
	public void setStatus(String status) {
		this.status = status;
	}

	/**
	 * @return the created
	 */
	public Date getCreated() {
		return this.created;
	}

	/**
	 * @param created
	 *            the created to set
	 */
	public void setCreated(Date createdDate) {
		this.created = createdDate;
	}

	/**
	 * @return the modified
	 */
	public Date getModified() {
		return this.modified;
	}

	/**
	 * @param modified
	 *            the modified to set
	 */
	public void setModified(Date lastUpdatedDate) {
		this.modified = lastUpdatedDate;
	}

	/**
	 * @return the usedFrom
	 */
	public String getUsedFrom() {
		return this.usedFrom;
	}

	/**
	 * @param usedFrom
	 *            the usedFrom to set
	 */
	public void setUsedFrom(String usedFrom) {
		this.usedFrom = usedFrom;
	}

	/**
	 * @return the loginName
	 */
	public String getLoginName() {
		return loginName;
	}

	/**
	 * @param loginName
	 *            the loginName to set
	 */
	public void setLoginName(String loginName) {
		this.loginName = loginName;
	}

	/**
	 * @return the userIdentifier
	 */
	public String getUserIdentifier() {
		return userIdentifier;
	}

	/**
	 * 
	 * @param userIdentifier
	 */
	public void setUserIdentifier(String userIdentifier) {
		this.userIdentifier = userIdentifier;
	}

	public ByteBuffer getPasswordHash() {
		return this.passwordHash;
	}

	public void setPasswordHash(ByteBuffer passwordHash) {
		this.passwordHash = passwordHash;
	}

	public String getPrivateUserINumber() {
		return privateUserINumber;
	}

	public void setPrivateUserINumber(String privateUserINumber) {
		this.privateUserINumber = privateUserINumber;
	}

	public List getPrivateSelectorINumbers() {
		return privateSelectorINumbers;
	}

	public void setPrivateSelectorINumbers(List privateSelectorINumbers) {
		this.privateSelectorINumbers = privateSelectorINumbers;
	}

	public String getOneTimePassword() {
		return oneTimePassword;
	}

	public void setOneTimePassword(String oneTimePassword) {
		this.oneTimePassword = oneTimePassword;
	}
	
	public Set getBlackListedSites() {
		return blackListedSites;
	}
	public void setBlackListedSites(Set blackListedSites) {
		this.blackListedSites = blackListedSites;
	}

}
