/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard;

import java.util.StringTokenizer;
import org.eclipse.higgins.icard.CardException;

public class CUID {
    protected String providerID;
    protected String issuer;
    protected String cardID;

    public CUID(String providerID, String issuer, String cardID) {
        this.providerID = providerID;
        this.issuer = issuer;
        this.cardID = cardID;
    }

    public CUID(String str) throws CardException {
        StringTokenizer t = new StringTokenizer(str, "#");
        if (t.countTokens() != 3) {
            throw new CardException("Invalid string representationformat of CUID: str=\"" + str + "\"");
        }
        this.providerID = t.nextToken();
        this.issuer = t.nextToken();
        this.cardID = t.nextToken();
    }

    public String getCardID() {
        return this.cardID;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public String getProviderID() {
        return this.providerID;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CUID) {
            CUID c = (CUID)obj;
            return (this.providerID == null ? c.providerID == null : this.providerID.equals(c.providerID)) && (this.issuer == null ? c.issuer == null : this.issuer.equals(c.issuer)) && (this.cardID == null ? c.cardID == null : this.cardID.equals(c.cardID));
        }
        if (obj instanceof String) {
            CUID c = null;
            try {
                c = new CUID((String)obj);
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
            return this.equals(c);
        }
        return false;
    }

    public int hashCode() {
        return (this.providerID == null ? 3 : this.providerID.hashCode()) * (this.issuer == null ? 5 : this.issuer.hashCode()) * (this.cardID == null ? 7 : this.cardID.hashCode());
    }

    public String toString() {
        return this.providerID + "#" + this.issuer + "#" + this.cardID;
    }
}

