/*******************************************************************************
 * Copyright (c) 2008 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergey Lyakhov - Initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.icard;

import java.util.EventListener;

/**
 * Interface for listening to <code>IInformationCardExtension</code> update
 * events
 * 
 */
public interface IExtensionListener extends EventListener {

	/**
	 * Method called when element of extenson has been changed
	 * 
	 * @param event
	 * @throws CardException
	 */
	public void extensionElementChanged(ICardExtensionEvent event) throws CardException;

	/**
	 * Method called when enabling mark of extenson has been changed
	 * 
	 * @param event
	 * @throws CardException
	 */
	public void extensionEnabledChanged(ICardExtensionEvent event) throws CardException;

}
