/**
 * Copyright (c) 2007 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergey Lyakhov - initial API and implementation
 */

package org.eclipse.higgins.icard;

import org.eclipse.higgins.icard.io.IElement;

/**
 * Represents CardSpace-interoperable I-Card
 */
public interface IInformationCard extends ICard {

	/**
	 * Random entropy used for computing the PPID claim value for the card
	 * 
	 * @return
	 */
	public byte[] getHashSalt();

	/**
	 * Used as the entropy to generate the token signing key
	 * 
	 * @return
	 * @throws CardException
	 */
	public byte[] getMasterKey() throws CardException;

	/**
	 * @param format
	 *            The document that will contain exported cards
	 * @return XML representation of the card in RoamingInformationCard format.
	 *         This <code>Element</code> should be created within the passed
	 *         <code>Document</code>
	 * @throws CardException
	 */
	// public IElement toElement(IElementFormat format) throws CardException,
	// CardIOException, UnsupportedElementFormatException;
	/**
	 * @return
	 */
	public byte[] getIssuerID();

	/**
	 * @return <code>true</code> if this card has any extension, otherwise
	 *         <code>false</code>
	 */
	public boolean hasExtensions();

	/**
	 * @return Extensions of this card
	 */
	public IInformationCardExtension[] getExtensions();

	/**
	 * @param extension
	 * @return
	 * @throws CardException
	 *             If this card is not in edit mode
	 */
	public IInformationCardExtension addExtension(IElement extension) throws CardException;

	/**
	 * Remove an extension from the card
	 * 
	 * @param extension
	 * @throws CardException
	 *             If this card is not in edit mode
	 */
	public void removeExtension(IInformationCardExtension extension) throws CardException;

}
