/*******************************************************************************
 * Copyright (c) 2007 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - Initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.icard;

import java.util.StringTokenizer;

public class TUID {
	protected String providerID;
	protected String templateID;

	public TUID(final String providerID, final String templateID) {
		this.providerID = providerID;
		this.templateID = templateID;
	}

	public TUID(String str) throws CardException {
		StringTokenizer t = new StringTokenizer(str, "#");
		if (t.countTokens() != 3) {
			throw new CardException("Invalid string representationformat of CUID: str=\"" + str + "\"");
		}
		providerID = t.nextToken();
		templateID = t.nextToken();
	}

	/**
	 * @return the cardID
	 */
	public String getTemplateID() {
		return templateID;
	}

	/**
	 * @return the providerID
	 */
	public String getProviderID() {
		return providerID;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	public boolean equals(Object obj) {
		if (obj instanceof TUID) {
			TUID c = (TUID) obj;
			return (this.providerID == null ? c.providerID == null : this.providerID.equals(c.providerID))
					&& (this.templateID == null ? c.templateID == null : this.templateID.equals(c.templateID));
		} else if (obj instanceof String) {
			TUID c = null;
			try {
				c = new TUID((String) obj);
			} catch (Exception e) {
				e.printStackTrace();
				return false;
			}
			return equals(c);
		}
		return false;
	}

	/**
	 * @return
	 * @see java.lang.String#hashCode()
	 */
	public int hashCode() {
		return (this.providerID == null ? 3 : this.providerID.hashCode())
				* ((this.templateID == null) ? 5 : this.templateID.hashCode());
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		return providerID + "#" + templateID;
	}
}
