/*******************************************************************************
 * Copyright (c) 2007-2008 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - Initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.icard.io;

/**
 * Interface representing i-card data prepared for input/output operations.
 * Provide conversions between underlying representations.
 */
public interface IElement
{
	/**
	 * Gets the Class of the contained object
	 * 
	 * @return the Class of the contained object (null if the contained object is null)
	 */
	public Class getObjectClass();
	
	/**
	 * Gets the array of the Classes supported by the underlying implementation
	 * 
	 * @return the array of the Classes supported by the underlying implementation
	 */
	public Class[] getSupportedClasses();

	/**
	 * Sets the contained object
	 * 
	 * @param object the object to set
	 */
	public void set(Object object) throws Exception;
	
	/**
	 * Gets a clone of the contained object
	 * 
	 * @return a clone of the contained object
	 */
	public Object get();
	
	/**
	 * Gets a clone of the contained object, converted to the Class specified by objectClass
	 * 
	 * @param objectClass the class of the object to be returned
	 * @return a clone of the contained object, converted to the Class specified by objectClass
	 */
	public abstract Object getAs(Class objectClass) throws Exception;
}
