/*******************************************************************************
 * Copyright (c) 2007-2008 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - Initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.icard.io;

import org.eclipse.higgins.icard.auth.ICredentialDescriptor;

public interface IFormatDescriptor {
	
	public String getID();

	/**
	 * Gets the name of describing input/output format.
	 */
	public String getName();

	/**
	 * Gets the file extension used by describing input/output format.
	 */
	public String getFileExtension();

	/**
	 * Gets human readable description of the describing input/output format.
	 */
	public String getDescription();

	/**
	 * Gets the description of the credentials required to operate with the
	 * describing input/output format.
	 */
	public ICredentialDescriptor getCredentialDescriptor();

	/**
	 * Gets the description of elements supported by the describing input/output
	 * format.
	 */
	public IElementFormat getElementDescriptor();
}