/*******************************************************************************
 * Copyright (c) 2006-2007 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - Initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.icard.policy;

import java.net.URL;
import org.eclipse.higgins.icard.IPolicy;

// import org.eclipse.higgins.icard.IProtocol;

public interface IRPPolicy extends IPolicy {
	/**
	 * Returns the URL of the relaying party site.
	 */
	public URL getSite();

	/**
	 * This parameter specifies the URL of the human-readable privacy policy of
	 * the site, if provided.
	 */
	public String getPrivacyUrl();

	/**
	 * This parameter specifies the privacy policy version. This must be a value
	 * greater than 0 if a privacyUrl is specified. If this value changes, the
	 * UI notifies the user and allows them review the change to the privacy
	 * policy.
	 */
	public String getPrivacyVersion();
}
