/**
 * Copyright (c) 2008 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergey Lyakhov - initial API and implementation
 */

package org.eclipse.higgins.icard;

import org.eclipse.higgins.icard.io.IElement;

/**
 * 
 * Interface represents an extension element of information card which is
 * supported by XML identity schema (see
 * http://schemas.xmlsoap.org/ws/2005/05/identity/identity.xsd,
 * tns:InformationCardType)
 * 
 */
public interface IInformationCardExtension {

	/**
	 * @return Is this extension enabled/disabled for processing
	 */
	public boolean isEnabled();

	/**
	 * Disable/enable this extension
	 * @param enabled
	 * @throws CardException
	 */
	public void setEnabled(boolean enabled)throws CardException;

	/**
	 * @return <code>IElement<code> which contain xml element of extension
	 */
	public IElement getElement();

	/**
	 * Modify this extension
	 * 
	 * @param extension
	 * @throws CardException
	 *             If this card is not in edit mode
	 */
	public void setElement(IElement extension) throws CardException;

	/**
	 * @return An associated object which uniquely identifies the extension
	 */
	public Object getId();

	/**
	 * @param obj
	 * @throws CardException
	 */
	public void setId(Object obj) throws CardException;

	/**
	 * Add listener
	 * 
	 * @param listener
	 */
	public void addListener(IExtensionListener listener);

	/**
	 * Remove listener
	 * 
	 * @param listener
	 */
	public void removeListener(IExtensionListener listener);
}
