/*******************************************************************************
 * Copyright (c) 2006-2007 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - Initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.icard;


/**
 * The <code>ISimpleClaimType</code> interface defines a set of methods to
 * describe simple types of an {@link IClaim} objects.
 */
public interface ISimpleClaimType extends IClaimType {
	/**
	 * Returns maximum count of values allowed for claim objects of this type.
	 */
	public int getMaxCardinality();
	
	/**
	 * Returns a <code>Class</code> object which represents a type of values
	 * of claim objects of this type.
	 */
	public Class getDataType();

	/**
	 * Converts given <code>lexicalForm</code> to value form of claim of this
	 * type.
	 * 
	 * @param stringValue
	 *            <code>String</code> value to be converted.
	 * @return an <code>Object</code> which represents valid value form of
	 *         claim object of this type.
	 * @throws InvalidValueException
	 *             if given <code>String</code> can't be converted.
	 */
	public Object fromString(String stringValue) throws InvalidValueException;

	/**
	 * Converts given <code>value</code> to string form of claim object of this type.
	 * 
	 * @param value
	 *            <code>Object</code> value to be converted.
	 * @return a <code>String</code> which represents valid lexical form of
	 *         claim of this type.
	 * @throws InvalidValueException
	 *             if given <code>Object</code> can't be converted.
	 */
	public String toString(Object value) throws InvalidValueException;
	
	/**
	 * Gets an UI descriptor which provides an information how to display claim
	 * value of this type.
	 */
	public IUIDescriptor getUIDescriptor();
}
