/*******************************************************************************
 * Copyright (c) 2006-2007 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Paul Trevithick - Initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.icard.auth;

import org.w3c.dom.Element;

public interface ICredentialDescriptor {

	public static final String SELF_ISSUED_CREDENTIAL = "SelfIssuedCredential";

	public static final String X509V3_CREDENTIAL = "X509V3Credential";

	public static final String KERBEROS_V5_CREDENTIAL = "KerberosV5Credential";

	public static final String USERNAME_PASSWORD_CREDENTIAL = "UsernamePasswordCredential";
	
	/**
	 * Gets the type of describing credential object.
	 */
	public String getType();

	/**
	 * Gets the credential hint to be displayed to the user when asking for his
	 * crenentials.
	 */
	public String getDisplayCredentialHint();

	/**
	 * Returns XML representation of this user credential object.
	 */
	public Element asXML();

	/**
	 * Gets an instance of ICredential object which should be used to provide
	 * credential information.
	 */
	public ICredential getCredential();
}
